/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EsgynDBManager
extends GeneralDBManager {
    private static final String[] keyWord = new String[]{"ALL", "ALTER", "ALIAS", "AND", "ANY", "AS", "ASC", "AT", "BEGIN", "BETWEEN", "BY", "CASE", "CHECK", "CLUSTERS", "CLUSTER", "COLAUTH", "COLUMNS", "COMPRESS", "CONNECT", "COUNT", "CRASH", "CREATE", "CURSOR", "DATE", "DECLARE", "DEFAULT", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPTION", "EXCLUSIVE", "FETCH", "FOR", "FOREIGN", "FROM", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOST", "IDENTIFIED", "IF", "IN", "INDEX", "INDEXES", "INSERT", "INTERSECT", "INTO", "IS", "LIKE", "LOCK", "LEVEL", "MINUS", "MODE", "NO", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "OVERLAPS", "PROCEDURE", "PUBLIC", "RESULT", "RESOURCE", "REVOKE", "SELECT", "SHARE", "SIZE", "SQL", "START", "SUBTYPE", "TABAUTH", "TABLE", "THEN", "TO", "TYPE", "UNION", "UNIQUE", "UPDATE", "VALUES", "VIEW", "VIEWS", "VISIBLE", "WHEN", "WHERE", "WITH", "LONG", "NUMBER", "INTEGER"};
    private Set<String> keySet = null;

    public EsgynDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    @Override
    public boolean checkTableExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getTableExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public String getTableExistCheckSql() {
        return "select count(OBJECT_NAME) from \"_MD_\".OBJECTS where UPPER(OBJECT_NAME) = ? and OBJECT_TYPE in ('BT') and SCHEMA_NAME = ?";
    }

    @Override
    public HashSet<String> getTableColumnSet(String string) throws Throwable {
        String string2 = this.getColumnCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public String getColumnCheckSql() {
        return "select C.COLUMN_NAME column_name from \"_MD_\".OBJECTS O, \"_MD_\".COLUMNS C where O.OBJECT_UID = C.OBJECT_UID and OBJECT_TYPE in ('BT') and UPPER(O.OBJECT_NAME) = ? and O.SCHEMA_NAME = ?";
    }

    @Override
    public HashSet<String> getIndexSet(String string) throws Throwable {
        String string2 = this.getIndexCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public String getIndexCheckSql() {
        return "select C.OBJECT_NAME as index_name from \"_MD_\".OBJECTS A, \"_MD_\".INDEXES B, \"_MD_\".OBJECTS C where A.OBJECT_UID = B.BASE_TABLE_UID and B.INDEX_UID = C.OBJECT_UID and A.OBJECT_NAME = ? and A.SCHEMA_NAME = ?";
    }

    public String getIndexSearchSql() {
        return "select A.OBJECT_NAME as table_name from \"_MD_\".OBJECTS A, \"_MD_\".INDEXES B, \"_MD_\".OBJECTS C where A.OBJECT_UID = B.BASE_TABLE_UID and B.INDEX_UID = C.OBJECT_UID and C.OBJECT_NAME = ? and A.SCHEMA_NAME = ?";
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add (";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + "," + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return (String)object + ")";
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " timestamp ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " double ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " int";
                break;
            }
            case 1011: {
                string = " clob ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1010: {
                string = " number";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728EsgynDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return stringBuilder.append("\"").append(string).append("\"");
        }
        return stringBuilder.append(string);
    }

    public int getDBType() {
        return 14;
    }

    @Override
    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (n3 == 101 && (n2 == 1006 || n2 == 1007 || n2 == 1005)) {
            return new BigDecimal((Double)object);
        }
        if (n3 == 100 && (n2 == 1007 || n2 == 1006 || n2 == 1005)) {
            return new BigDecimal(((Float)object).floatValue());
        }
        return super.convert(object, n2, n3);
    }

    @Override
    public int convertDataType(int n2) {
        if (n2 == 101) {
            return 1006;
        }
        if (n2 == 100) {
            return 1007;
        }
        return super.convertDataType(n2);
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string;
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.insert(stringBuilder2.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string2;
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String charSequence, boolean bl, int n2, int n3) {
        if (charSequence != null && ((String)charSequence).length() != 0) {
            string = string + " order by " + (String)charSequence;
        }
        charSequence = new StringBuilder(string.length() + 100);
        PrepareSQL prepareSQL = new PrepareSQL();
        if (bl) {
            ((StringBuilder)charSequence).append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            ((StringBuilder)charSequence).append("select * from ( ");
        }
        ((StringBuilder)charSequence).append(string);
        if (bl) {
            ((StringBuilder)charSequence).append(" ) row_ ) where rownum_ > ? and rownum_ <= ? ");
            prepareSQL.addValue((Object)n2);
            prepareSQL.addValue((Object)n3);
        } else {
            ((StringBuilder)charSequence).append(" ) where rownum <= ?");
            prepareSQL.addValue((Object)n3);
        }
        prepareSQL.setSQL(((StringBuilder)charSequence).toString());
        return prepareSQL;
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        PreparedStatement preparedStatement;
        block5: {
            String string = this.getTableStructSql();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getSchema());
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initTable(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getColumnStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initColumn(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getIndexStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initIndex(resultSet);
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }

    public String getTableStructSql() {
        return "select OBJECT_NAME as TABLE_NAME from \"_MD_\".OBJECTS where OBJECT_TYPE in ('BT') and SCHEMA_NAME = ?";
    }

    public String getColumnStructSql() {
        return "select b.COLUMN_NAME as column_name, c.OBJECT_NAME as table_name from \"_MD_\".OBJECTS c, \"_MD_\".COLUMNS b where b.OBJECT_UID = c.OBJECT_UID and c.OBJECT_TYPE in ('BT') and c.SCHEMA_NAME = ?";
    }

    public String getIndexStructSql() {
        return "select C.OBJECT_NAME as index_name,A.OBJECT_NAME as table_name, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from \"_MD_\".OBJECTS A, \"_MD_\".INDEXES B, \"_MD_\".OBJECTS C where A.OBJECT_UID = B.BASE_TABLE_UID and B.INDEX_UID = C.OBJECT_UID and A.SCHEMA_NAME = ?";
    }

    public String getViewExistCheckSql() {
        return null;
    }

    public String getViewStructSql() {
        return null;
    }
}

