package com.bokesoft.yigo.mid.util.resource.icon.css.generator;

import java.io.InputStream;

import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontItem;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.util.resource.icon.SourceIdentifier;

public class DefaultGenerator implements ICSSSourceGenerator {

	public static final String CSS_TAG = "dflt";

	@Override
	public String getIconClassName(IMetaFactory factory, MetaIconSource iconSource) {
		String scene = iconSource.getScene();
		return PREFIX_CLASS + iconSource.getKey()
				+ (scene == null || scene.isEmpty() ? "" : "-" + iconSource.getScene());
	}

	@Override
	public String generateIcon(IMetaFactory factory, MetaIconSource iconSource) throws Throwable {
		String source = iconSource.getSource();
		StringBuilder string = new StringBuilder();
		SourceIdentifier identifier = SourceIdentifier.parse(source);
		String className = this.getIconClassName(factory, iconSource);
		if (identifier == null) {
			throw new Exception("the source definition does not comply with the rules:" + source);
		}

		switch (identifier.getType()) {
		case SourceIdentifier.TYPE_EMPTY: {
			string.append(this.generateEmpty(className));
			break;
		}
		case SourceIdentifier.TYPE_RESOURCE: {
			string.append(
					this.generateResource(className, factory, identifier.getContent(), iconSource.getSolutionKey()));
		}
			break;
		case SourceIdentifier.TYPE_BASE64: {
			string.append(this.generateBase64(className, identifier.getContent()));
			break;
		}
		case SourceIdentifier.TYPE_ICONFONT: {
			string.append(
					this.generateIconFont(factory, identifier.getContent(), className, iconSource.getSolutionKey()));
			break;
		}
		default:
			break;
		}

		return string.toString();
	}

	@Override
	public String getTag() {
		return CSS_TAG;
	}

	protected static boolean isUnicode(String input) {
		try {
			if (input.startsWith("\\")) {
				input = input.substring(1);
				if (input.length() < 4) {
					input = "0000".substring(input.length()) + input;
				}
				int codePoint = Integer.parseInt(input, 16);
				return Character.isValidCodePoint(codePoint);
			}
		} catch (NumberFormatException e) {
			return false;
		}
		return false;
	}

	protected String generateEmpty(String className) {
		return "." + className + "{ }";
	}

	protected String generateResource(String className, IMetaFactory factory, String content, String solutionKey)
			throws Throwable {
		StringBuilder string = new StringBuilder();
		string.append(".");
		string.append(className);
		string.append("{");
		string.append("background-image:");
		string.append("url(");
		InputStream inputStream = factory.loadResourceBySolutionKey("/Resource/" + content, solutionKey);
		if (inputStream == null) {
			throw new Exception("file does not exit:" + content);
		}
		string.append(GenerateUtil.getBase64StrByInputStream(inputStream, content));
		string.append(")");
		string.append(";");

//        string.append("background-repeat: no-repeat;");
//        string.append("background-size: cover;");
//        string.append("background-position: center center;");

		string.append("}");
		return string.toString();
	}

	protected String generateBase64(String className, String content) throws Throwable {

		return "." + className + "{background-image:url(" + content + ");" +
//                "background-repeat: no-repeat;" +
//                "background-size: cover;" +
//                "background-position: center center;" +
				"}";
	}

	protected String generateIconFont(IMetaFactory factory, String content, String className, String solutionKey)
			throws Throwable {
		StringBuilder string = new StringBuilder();
		String[] split = content.split("\\.");
		String familyName = split[0];
		String iconName = split[1];
		// 字体
		string.append(".");
		string.append(className);
		string.append("{");
		string.append("font-family:").append(familyName).append(";");
		string.append("}");
		string.append("\r\n");

		String unitcode = null;
		if (!DefaultGenerator.isUnicode(iconName)) {
			MetaIconFontSource iconfont = factory.getIconFontSourceCollection().get(familyName);
			if (iconfont != null) {
				InputStream inputStream = factory.loadResourceBySolutionKey("/Resource/" + iconfont.getSource(),
						solutionKey);
				// 预先检查字体库是否存在
				if (inputStream == null) {
					throw new Exception("file does not exit:" + iconfont.getSource());
				}

				MetaIconFontItem item = iconfont.getItemCollection().get(iconName);
				if (item != null) {
					unitcode = item.getCode();
				}
			} else {
				throw new Exception("iconfont is not defined");
			}
		} else {
			unitcode = iconName;
		}
		if (unitcode != null && !unitcode.isEmpty()) {
			// 图标
			string.append(".");
			string.append(className);
			string.append(":before");
			string.append("{");
			string.append("content:\"").append(unitcode).append("\";");
//            string.append("align-items: center;");
//            string.append("justify-content: center;");
//            string.append("display: flex;");
//            string.append("height: 100%;");
//            string.append("width: 100%;");
			string.append("}");
		} else {
			throw new Exception("iconfont unitcode is not defined");
		}
		return string.toString();
	}
}
