package com.bokesoft.yigo.mid.util.resource.icon.css;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.DefaultGenerator;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.ICSSSourceGenerator;

public class CssSourceGeneratorFactory {

	private static final StringHashMap<ICSSSourceGenerator> generatorMap = new StringHashMap<>();

	private static ICSSSourceGenerator defaultGenerator = new DefaultGenerator();

	public static void registerGenerator(ICSSSourceGenerator generator) {
		generatorMap.put(generator.getTag(), generator);
	}

	public static ICSSSourceGenerator getGenerator(String scene) throws Throwable {
		if (scene == null || scene.isEmpty()) {
			return defaultGenerator;
		}
		ICSSSourceGenerator generator = generatorMap.get(scene);
		if (generator == null) {
			return defaultGenerator;
		}
		return generator;
	}

}
