package com.bokesoft.yigo.mid.session;

import com.bokesoft.yigo.common.struct.PairItemList;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * ISessionParaItemsProvider用于为会话集参数选择的下拉框提供下拉项列表，根据操作员代码实现不同的下拉项列表。
 * 如果界面上有多个回话级参数,那么可以通过DefaultContext的getPara()方法取得某一个参数的值
 * @author wangyh
 *
 */
public interface ISessionParaItemsProvider {
	/**
	 * 载入下拉项列表
	 * @param context 上下文
	 * @param user 操作员代码
	 * @return 跟user相关的可用下拉项列表
	 * @throws Throwable
	 */
	public PairItemList loadItems(DefaultContext context, String user) throws Throwable;
}
