package com.bokesoft.yigo.mid.session;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.mid.session.LogOvertime;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.env.Env;

import java.util.Date;
import java.util.Set;

public class EvictExpiredSession {

    public void doEvict(DefaultContext context) throws Throwable {

        /**
         *  PC端过期session移至overtime集合
         */
        evictExpiredSessions(context, LoginMode.PC);

        /**
         *  移动端过期session移至overtime集合
         */
        evictExpiredSessions(context,LoginMode.MOBILE);

        /**
         *  临时session直接清除不移至overtime集合
         */
        evictExpiredSessions(context,LoginMode.TEMP);

        /**
         *  清除临时session
         */
        evictExpiredOvertimeSessions(context, SessionInfoProviderHolder.getOvertimeProvider());
    }

    private void evictExpiredOvertimeSessions(DefaultContext context, ISessionInfoProvider provider) throws Throwable {
        try {
            ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
            Set<String> keys = sessionInfoMap.getKeys();
            int timeout = sessionInfoMap.getTimeout();

            Date date = null;
            ISessionInfo session = null;

            for( String clientID : keys ) {
                session = sessionInfoMap.get(clientID);
                if( session != null ) {
                    if( session.getType() == ISessionInfo.Normal ) {
                        date = session.getLastActiveTime();
                    } else {
                        date = session.getCreateTime();
                    }
                    if( (DateUtil.getNowTime().getTime() - date.getTime()) >= timeout * 1000L) {
                        LogSvr.getInstance().debug("清空超时clientID:"+clientID);
                        sessionInfoMap.remove(clientID);
                    }
                }
            }
        } catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(),e);
        }
    }

    private void evictExpiredSessions(DefaultContext context, int mode) throws Throwable {
        ISessionInfoProvider provider = SessionInfoProviderHolder.getProvider(mode);
        ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
        Set<String> keys = sessionInfoMap.getKeys();
        int timeout = sessionInfoMap.getTimeout();
        Env env = context.getVE().getEnv();

        Date date = null;
        ISessionInfo session = null;

        for( String clientID : keys ) {
            session = sessionInfoMap.get(clientID);
            if( session != null ) {
                if( session.getType() == ISessionInfo.Normal ) {
                    date = session.getLastActiveTime();
                } else {
                    date = session.getCreateTime();
                }
                if( (DateUtil.getNowTime().getTime() - date.getTime()) >= timeout * 1000L) {
                    try {
                        if( mode != LoginMode.TEMP ) {
                            env.setClientID(clientID);
                            env.setUserID(session.getOperatorID());
                            env.setMode(session.getMode());
                            env.setClusterid(session.getClusterID());
                            new LogOvertime().doLogOvertime(context);
                        } else {
                            sessionInfoMap.remove(clientID); // 临时session直接清除
                        }
                    } catch (Exception e) {
                        LogSvr.getInstance().error(e.getMessage(),e);
                        sessionInfoMap.remove(clientID);
                    }
                }
            }
        }
    }
}
