package com.bokesoft.yigo.mid.report;

import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 打印模版提供者工厂类, 主要用于项目上的二开实现类
 * 1. 添加/移除提供者二开实现类
 * 2. 根据formKey和document获取打印模版标识
 */
public class MidReportProviderFactory {

    private static List<IMidReportProvider> midReportProviderList;

    /**
     * 添加打印模版标识提供者的二开实现类
     *
     * @param reportKeyProvider 二开实现类
     */
    public static void addProvider(IMidReportProvider reportKeyProvider) {
        if (midReportProviderList == null) {
            midReportProviderList = new ArrayList<>();
        }
        midReportProviderList.add(reportKeyProvider);
    }

    /**
     * 添加打印模版标识提供者的二开实现类们.<br/>
     * 例如：addProviders(new ReportKeyProvider1(), new ReportKeyProvider2());
     *
     * @param reportKeyProviders 二开实现类们
     */
    public static void addProviders(IMidReportProvider... reportKeyProviders) {
        if (reportKeyProviders == null) {
            return;
        }
        if (MidReportProviderFactory.midReportProviderList == null) {
            MidReportProviderFactory.midReportProviderList = new ArrayList<>();
        }
        MidReportProviderFactory.midReportProviderList.addAll(Arrays.asList(reportKeyProviders));
    }

    /**
     * 根据formKey和document获取打印模版标识
     *
     * @param formKey  表单标识
     * @param document 表单当前数据源
     * @return 打印模版
     */
    public static MetaReport getMetaReport(DefaultContext context, String formKey, Document document) {
        if (midReportProviderList == null) return null;
        MetaReport metaReport = null;
        for (IMidReportProvider reportProvider : midReportProviderList) {
            if (reportProvider != null) {
                try {
                    metaReport = reportProvider.getMetaReport(context, formKey, document);
                } catch (Throwable e) {
                    LogSvr.getInstance().error("MidReportProviderFactory getMetaReport", e);
                }
            }
            if (metaReport != null) break;
        }
        return metaReport;
    }
}
