package com.bokesoft.yigo.mid.report;

import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 打印模版提供者接口，根据特定规则获取对应的打印模版，主要提供给项目上二开使用
 */
public interface IMidReportProvider {

    /**
     * 根据表单标识，以及表单当前数据源获取对应的打印模版标识。
     *
     * @param context  上下文对象
     * @param formKey  表单标识
     * @param document 表单当前数据源对象
     * @return 对应的打印模版标识
     */
    MetaReport getMetaReport(DefaultContext context, String formKey, Document document);
}
