package com.bokesoft.yigo.mid.query;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.cmd.data.MetaQueryUtil;
import com.bokesoft.yes.mid.relation.RelationProxy;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.common.MetaStatementCollection;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.path.MetaRelationProxy;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DBType;
import com.bokesoft.yigo.mid.connection.IDBManager;

/**
 * 执行命名的更新语句，并返回受影响的行数
 * @author wangyh
 *
 */
public class DBNamedUpdate {
	/** 上下文 */
	private BaseContext context = null;
	/** 表单标识 */
	private String formKey = "";
	/** 查询名称 */
	private String name = "";
	/** 查询的参数*/
	private List<Object> args;
	
	/**
	 * 构造一个DBNamedUpdate实例
	 * @param context 上下文
	 * @param formKey 表单标识
	 * @param name 预定义的查询标识
	 * @param args 查询语句中问号参数的集合
	 */
	public DBNamedUpdate(BaseContext context, String formKey, String name, List<Object> args) {
		this.context = context;
		this.formKey = formKey;
		this.name = name;
		this.args = args;
	}
	
	/**
	 * 执行在formKey可到达的范围内的指定标识的更新语句，并返回受影响的行数
	 * @return 受影响的行数
	 * @throws Throwable 如果指定标识的查询未定义，抛出MetaException或者SQL执行过滤中的异常
	 */
	public int exec() throws Throwable {
		String sql = "";
		IDBManager dbManager = context.getDBManager();
		
		MetaQuery query = MetaQueryUtil.getQuery(context.getVE(), formKey, name);
		
		if( query == null ) {
			throw new MetaException(MetaException.NAMED_QUERY_NOT_FOUND, 
					SimpleStringFormat.format(StringTable.getString(context.getEnv(), "", 
							StringTable.NamedQueryNotFound), name, formKey));
		}
		
		
		// 取与环境中相同的数据库类型的content
		MetaStatementCollection statements = query.getStatements();
				
		if (statements != null && statements.size() != 0) {
			int dbType = context.getVE().getDSN().getDBType();
			for (int i = 0, size = statements.size(); i < size; i++) {
				MetaStatement statement = statements.get(i);
				String type = statement.getDBType();
				if (type.isEmpty()) {
					sql = statement.getContent();
				} else {
					if (dbType == DBType.parse(type)) {
						sql = statement.getContent();
						break;
					}
				}
			}
		}
		
		//安全检查
		preCheck();

		if (query.getParameters() != null && query.getParameters().size() != 0) {
			MetaSecurityFilter securityFilter = context.getVE().getMetaFactory().getSecurityFilter(null);
			if (securityFilter != null) {
				MetaRelationProxy proxy = securityFilter.getRelationproxy();
				String impl = proxy.getImpl();
				Object o = ReflectHelper.newInstance(context.getVE(), impl);
				RelationProxy relationProxy = (RelationProxy) o;
				relationProxy.checkScript(context, formKey, name, args, proxy.isCache());
			}
		}
		
		//配置中定义的参数类型
		MetaParameterCollection parameterCollection = query.getParameters();
		List<Integer> dataTypes = null;
		int count = 0;
		if( parameterCollection != null && !parameterCollection.isEmpty()) {
			dataTypes = parameterCollection.getDataTypes();
			
			//值转换
			int dataType = -1;
			List<Object> values = new ArrayList<Object>();
			for( int i = 0; i < args.size(); i++ ){
				dataType = dataTypes.get(i);
				values.add(TypeConvertor.toDataType(dataType, args.get(i)));
			}
			
			count = dbManager.execPrepareUpdate(sql, dataTypes, values);
		}else{
			count = dbManager.execPrepareUpdate(sql, dataTypes, args);
		}
	
		return count;
	}
	/**
	 * 
	 * @throws Throwable
	 */
	private void preCheck() throws Throwable {
		if (context instanceof DefaultContext) {
			MidProcessFlowHandler handler = new MidProcessFlowHandler("DBNamedUpdate", "Pre");
			handler.doDefaultProcessWithArgs((DefaultContext) context, formKey, name, args);
		} 
	}
}
