package com.bokesoft.yigo.mid.process;

import java.util.Set;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.auth.cache.SessionUtil;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.extend.IMidProcess;
import com.bokesoft.yigo.mid.session.*;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;

/**
 * 获取登录人员信息二开,如果mode为-1,查出所有的人数,否者查出对应登陆模式的人数
 * 
 * @author 陈瑞
 *
 */
public class GetLoginOperatorsProcess implements IMidProcess<DefaultContext>{
	
	@Override
	public Object process(DefaultContext context) throws Throwable {
		
		// 权限检查
		if( !SessionUtil.isAdmin(context) ) {
			throw MidCoreException.createException(context.getEnv(), MidCoreException.PERMISSION_DENIED);
		}
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(context.getFormKey());
		MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
		
		String tableKey = (String) context.getPara("tableKey");
		MetaTable metaTable = dataObject.getTable(tableKey);
		DataTable table = DataTableUtil.newEmptyDataTable(metaTable);

		new EvictExpiredSession().doEvict(context);
		
		int mode = context.getEnv().getMode();
		if( mode == -1 ) {
			loadUser(table, LoginMode.PC);
			loadUser(table, LoginMode.MOBILE);
		} else {
			loadUser(table, mode);
		}
		return table;
	}
	
	private void loadUser(DataTable table,int mode) {
		ISessionInfoProvider provider = SessionInfoProviderHolder.getProvider(mode);
		ISessionInfoMap cache = provider.getSessionInfoMap();
		Set<String> keys = cache.getKeys();
		if( keys == null || keys.isEmpty() ) 
			return;
		ISessionInfo session = null;
		for( String key : keys ) {
			session = cache.get(key);
			if( session == null || session.getType() == ISessionInfo.Temp )
				continue;

			table.append();
			table.setObject("Mode", session.getMode());
			table.setObject("ClientID", session.getClientID());
			table.setObject("OperatorID", session.getOperatorID());
			table.setObject("IP", session.getIP());
			table.setObject("LoginTime", session.getLoginTime());
			table.setObject("LastActiveTime", session.getLastActiveTime());
			table.setObject("ClusterID", session.getClusterID());
		}
	}

}