package com.bokesoft.yigo.mid.map;

import com.bokesoft.yes.datamap.struct.MapResult;
import com.bokesoft.yes.mid.cmd.datamap.MidMapCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 中间层下推入口，为二次开发提供的下推类集合
 * @author chenyf
 *
 */
public class MidDataMapUtil {
	/**
	 * 中间层分组下推并直接保存
	 * @param context 	包含下推源数据的上下文环境
	 * @param mapKey 	映射关系标志
	 * @param sysTopic 	系统主题
	 * @throws Throwable
	 * @return 成功执行映射,返回true,无映射量返回false
	 */
	public boolean mapData(DefaultContext context, String mapKey) throws Throwable {
		MapData mapData = new MapData(mapKey);
		return mapData.map(context);
	}
	
	/**
	 * 中间层下推并保存(不计算分组下推情况)
	 * @param context		上下文环境
	 * @param mapKey		映射关系标志
	 * @param srcDocument	下推源数据集
	 * @param sysTopic 		系统主题
	 * @throws Throwable
	 */
	public void mapWithSave(DefaultContext context, String mapKey, Document srcDocument) throws Throwable {
		MidMapCmd cmd = new MidMapCmd();
		cmd.setMapKey(mapKey);
		cmd.setSaveTarget(true);
		cmd.doCmd(context);
	}
	
	/**
	 * 中间层下推并保存(不计算分组下推情况)
	 * @param context		上下文环境
	 * @param mapKey		映射关系标志
	 * @param srcDocument	下推源数据集
	 * @param tgtDocument	下推目标数据集
	 * @param sysTopic 		系统主题
	 * @throws Throwable
	 */
	public void mapWithSave(DefaultContext context, String mapKey, Document srcDocument, Document tgtDocument) throws Throwable {
		MidMapCmd cmd = new MidMapCmd();
		cmd.setMapKey(mapKey);
		cmd.setSrcDoc(srcDocument);
		cmd.setTgtDoc(tgtDocument);
		cmd.setSaveTarget(true);
		cmd.doCmd(context);
	}
	
	/**
	 * 中间层下推
	 * @param context		上下文环境
	 * @param mapKey		映射关系标志
	 * @param srcDocument	下推源数据集
	 * @param tgtFormKey	目标表FormKey,用于检查列扩展,可以为空
	 * @param sysTopic 		系统主题
	 * @return Document		返回下推后的数据集
	 * @throws Throwable
	 */
	public Document mapWithoutSave(DefaultContext context, String mapKey, Document srcDocument, String tgtFormKey) throws Throwable {
		MidMapCmd cmd = new MidMapCmd();
		cmd.setMapKey(mapKey);
		cmd.setSrcDoc(srcDocument);
		cmd.setTgtFormKey(tgtFormKey);
		MapResult result = (MapResult) cmd.doCmd(context);
		return result.getDocument();
	}
	
	/**
	 * 中间层下推
	 * @param context		上下文环境
	 * @param mapKey		映射关系标志
	 * @param srcDocument	下推源数据集
	 * @param tgtDocument	下推目标数据集
	 * @param sysTopic 		系统主题
	 * @return Document		返回下推后的数据集
	 * @throws Throwable
	 */
	public Document mapWithoutSave(DefaultContext context, String mapKey, Document srcDocument, Document tgtDocument) throws Throwable {
		MidMapCmd cmd = new MidMapCmd();
		cmd.setMapKey(mapKey);
		cmd.setSrcDoc(srcDocument);
		cmd.setTgtDoc(tgtDocument);
		MapResult result = (MapResult) cmd.doCmd(context);
		return result.getDocument();
	}
}