package com.bokesoft.yigo.mid.map;

import com.bokesoft.yes.mid.datamap.calculate.MapMidUtil;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;

/**
 * 映射数据的工具类
 * 
 * @author 刘翔翔
 *
 */
public class MapToForm {
	/** 映射 KEY */
	private String mapKey;

	/** 源单 Document */
	private Document srcDocument = null;

	/** 目标单 */
	private Document targetDocument = null;

	/**
	 * 上引下推
	 * 
	 * @param mapKey
	 *            映射 KEY
	 * @param srcDocument
	 *            下推的数据源
	 * @param targetDocument
	 *            下推的目标单数据源
	 */
	public MapToForm(String mapKey, Document srcDocument, Document targetDocument) {
		this.mapKey = mapKey;
		this.srcDocument = srcDocument;
		this.targetDocument = targetDocument;
	}

	/**
	 * 普通下推（不执行分组分量的逻辑）
	 * 
	 * @param mapKey
	 *            映射 KEY
	 * @param srcDocument
	 *            下推的数据源
	 * @param context
	 *            上下文
	 * @throws Throwable
	 */
	public MapToForm(String mapKey, Document srcDocument, DefaultContext context) throws Throwable {
		this.mapKey = mapKey;
		this.srcDocument = srcDocument;

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaMap metaMap = metaFactory.getDataMap(mapKey);
		MetaDataObject targetDataObject = metaFactory.getDataObject(metaMap.getTgtDataObjectKey());
		targetDocument = DocumentUtil.newDocument(targetDataObject);
		targetDocument.setNew();
	}

	/**
	 * 执行映射
	 * 
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public Document map(DefaultContext context) throws Throwable {
		MapMidUtil.MapToForm(context, mapKey, srcDocument, targetDocument);
		return targetDocument;
	}

}
