package com.bokesoft.yigo.mid.map;

import java.util.Comparator;
import java.util.List;

import com.bokesoft.yes.mid.datamap.calculate.MapMidUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadData;
import com.bokesoft.yigo.struct.document.FilterMap;

/**
 * BatchMidMap为批量映射，即根据某个映射关系，依赖根据源集合分别映射产生目标
 * @author wangyh
 *
 */
public class BatchMidMap {
	/** 映射关系标识 */
	private String mapKey = null;
	/** 数据对象唯一标识列表 */
	private List<Long> OIDList = null;
	
	/**
	 * 设置映射关系标识
	 * @param mapKey 映射关系标识
	 */
	public void setMapKey(String mapKey) {
		this.mapKey = mapKey;
	}
	
	/**
	 * 设置数据对象唯一标识列表
	 * @param OIDList 数据对象唯一标识列表
	 */
	public void setOIDList(List<Long> OIDList) {
		this.OIDList = OIDList;
	}
	
	/**
	 * 映射
	 * @param context 上下文
	 * @throws Throwable 可能的异常
	 */
	public void map(DefaultContext context) throws Throwable {
		String tgtDataObjectKey = context.getVE().getMetaFactory().getDataMap(mapKey).getSrcDataObjectKey();
		OIDList.sort(new Comparator<Long>() {

			@Override
			public int compare(Long o1, Long o2) {
				return o1.compareTo(o2);
			}
		});
		for (Long OID : OIDList) {
			DefaultContext dc = new DefaultContext(context);
			FilterMap filterMap = new FilterMap();
			filterMap.setOID(OID);
			LoadData loadData = new LoadData(tgtDataObjectKey, filterMap, null);
			loadData.load(dc, null);
			MapMidUtil.midMapData(dc, mapKey);
		}
	}
}
