package com.bokesoft.yigo.mid.log;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

public class LogData implements JSONSerializable{
	
	private long instanceID=-1;
	private long oid = -1;
	private Integer logID = -1;
	private Integer logIndex = -1;
	private int inlineNodeID = -1;
	private Integer nodeID = -1;
	private Long workitemID = -1l;
	private String workitemName = "";
	private Integer workitemState = -1;
	private Timestamp createTime = new Timestamp(0);
	private Timestamp finishTime = new Timestamp(0);
	private Long operatorID = 0L;
	private int auditResult = -1;
	private String userInfo = "";
	private String resultInfo = "";
	private String launchInfo = "";
	private int transactionID = -1;
	private int assistTransactionID = -1;
	private int mapCount = -1;
	private int slock = -1;
	
	/**
	 * @return the instanceID
	 */
	public long getInstanceID() {
		return instanceID;
	}
	/**
	 * @param instanceID the instanceID to set
	 */
	public void setInstanceID(long instanceID) {
		this.instanceID = instanceID;
	}
	/**
	 * @return the oid
	 */
	public long getOid() {
		return oid;
	}
	/**
	 * @param oid the oid to set
	 */
	public void setOid(long oid) {
		this.oid = oid;
	}
	/**
	 * @return the logID
	 */
	public Integer getLogID() {
		return logID;
	}
	/**
	 * @param logID the logID to set
	 */
	public void setLogID(Integer logID) {
		this.logID = logID;
	}
	/**
	 * @return the logIndex
	 */
	public Integer getLogIndex() {
		return logIndex;
	}
	/**
	 * @param logIndex the logIndex to set
	 */
	public void setLogIndex(Integer logIndex) {
		this.logIndex = logIndex;
	}
	/**
	 * @return the inlineNodeID
	 */
	public int getInlineNodeID() {
		return inlineNodeID;
	}
	/**
	 * @param inlineNodeID the inlineNodeID to set
	 */
	public void setInlineNodeID(int inlineNodeID) {
		this.inlineNodeID = inlineNodeID;
	}
	/**
	 * @return the nodeID
	 */
	public Integer getNodeID() {
		return nodeID;
	}
	/**
	 * @param nodeID the nodeID to set
	 */
	public void setNodeID(Integer nodeID) {
		this.nodeID = nodeID;
	}
	/**
	 * @return the workitemID
	 */
	public Long getWorkitemID() {
		return workitemID;
	}
	/**
	 * @param workitemID the workitemID to set
	 */
	public void setWorkitemID(Long workitemID) {
		this.workitemID = workitemID;
	}
	/**
	 * @return the workitemName
	 */
	public String getWorkitemName() {
		return workitemName;
	}
	/**
	 * @param workitemName the workitemName to set
	 */
	public void setWorkitemName(String workitemName) {
		this.workitemName = workitemName;
	}
	/**
	 * @return the workitemState
	 */
	public Integer getWorkitemState() {
		return workitemState;
	}
	/**
	 * @param workitemState the workitemState to set
	 */
	public void setWorkitemState(Integer workitemState) {
		this.workitemState = workitemState;
	}
	/**
	 * @return the createTime
	 */
	public Timestamp getCreateTime() {
		return createTime;
	}
	/**
	 * @param createTime the createTime to set
	 */
	public void setCreateTime(Timestamp createTime) {
		this.createTime = createTime;
	}
	/**
	 * @return the finishTime
	 */
	public Timestamp getFinishTime() {
		return finishTime;
	}
	/**
	 * @param finishTime the finishTime to set
	 */
	public void setFinishTime(Timestamp finishTime) {
		this.finishTime = finishTime;
	}
	/**
	 * @return the operatorID
	 */
	public Long getOperatorID() {
		return operatorID;
	}
	/**
	 * @param operatorID the operatorID to set
	 */
	public void setOperatorID(Long operatorID) {
		this.operatorID = operatorID;
	}
	/**
	 * @return the auditResult
	 */
	public int getAuditResult() {
		return auditResult;
	}
	/**
	 * @param auditResult the auditResult to set
	 */
	public void setAuditResult(int auditResult) {
		this.auditResult = auditResult;
	}
	/**
	 * @return the userInfo
	 */
	public String getUserInfo() {
		return userInfo;
	}
	/**
	 * @param userInfo the userInfo to set
	 */
	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}
	/**
	 * @return the resultInfo
	 */
	public String getResultInfo() {
		return resultInfo;
	}
	/**
	 * @param resultInfo the resultInfo to set
	 */
	public void setResultInfo(String resultInfo) {
		this.resultInfo = resultInfo;
	}
	/**
	 * @return the launchInfo
	 */
	public String getLaunchInfo() {
		return launchInfo;
	}
	/**
	 * @param launchInfo the launchInfo to set
	 */
	public void setLaunchInfo(String launchInfo) {
		this.launchInfo = launchInfo;
	}
	/**
	 * @return the transactionID
	 */
	public int getTransactionID() {
		return transactionID;
	}
	/**
	 * @param transactionID the transactionID to set
	 */
	public void setTransactionID(int transactionID) {
		this.transactionID = transactionID;
	}
	/**
	 * @return the assistTransactionID
	 */
	public int getAssistTransactionID() {
		return assistTransactionID;
	}
	/**
	 * @param assistTransactionID the assistTransactionID to set
	 */
	public void setAssistTransactionID(int assistTransactionID) {
		this.assistTransactionID = assistTransactionID;
	}
	/**
	 * @return the mapCount
	 */
	public int getMapCount() {
		return mapCount;
	}
	/**
	 * @param mapCount the mapCount to set
	 */
	public void setMapCount(int mapCount) {
		this.mapCount = mapCount;
	}
	/**
	 * @return the slock
	 */
	public int getSlock() {
		return slock;
	}
	/**
	 * @param slock the slock to set
	 */
	public void setSlock(int slock) {
		this.slock = slock;
	}
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject obj = new JSONObject();
		obj.put("instanceID", instanceID);
		obj.put("oid", oid);
		obj.put("logID", logID);
		obj.put("logIndex", logIndex);
		obj.put("inlineNodeID", inlineNodeID);
		obj.put("nodeID", nodeID);
		obj.put("workitemID", workitemID);
		obj.put("workitemName", workitemName);
		obj.put("workitemState", workitemState);
		obj.put("createTime", createTime.toString());
		obj.put("finishTime", finishTime.toString());
		obj.put("operatorID", operatorID);
		obj.put("auditResult", auditResult);
		obj.put("userInfo", userInfo);
		obj.put("resultInfo", resultInfo);
		obj.put("launchInfo", launchInfo);
		obj.put("transactionID", transactionID);
		obj.put("assistTransactionID", assistTransactionID);
		obj.put("mapCount", mapCount);
		obj.put("slock", slock);
		
		return obj;
	}
	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		
		instanceID = jsonObj.optLong("instanceID");
		oid = jsonObj.optLong("oid");
		logID = jsonObj.optInt("logID");
		logIndex = jsonObj.optInt("logIndex");
		inlineNodeID = jsonObj.optInt("inlineNodeID");
		nodeID = jsonObj.optInt("nodeID");
		workitemID = jsonObj.optLong("workitemID");
		workitemName = jsonObj.optString("workitemName");
		workitemState = jsonObj.optInt("workitemState");
		String createTimestr = jsonObj.optString("createTime");
		createTime = Timestamp.valueOf(createTimestr);
		String finishTimeStr = jsonObj.optString("finishTime");
		finishTime = Timestamp.valueOf(finishTimeStr);
		operatorID = jsonObj.optLong("operatorID");
		auditResult = jsonObj.optInt("auditResult");
		userInfo = jsonObj.optString("userInfo");
		resultInfo = jsonObj.optString("resultInfo");
		launchInfo = jsonObj.optString("launchInfo");
		transactionID = jsonObj.optInt("transactionID");
		assistTransactionID = jsonObj.optInt("assistTransactionID");
		mapCount = jsonObj.optInt("mapCount");
		slock = jsonObj.optInt("slock");
		
	}
	
	public void populate(ResultSet rest) throws SQLException {
		instanceID = rest.getLong("InstanceID");
		oid = rest.getLong("OID");
		logID = rest.getInt("LogID");
		auditResult = rest.getInt("AuditResult");
		createTime = rest.getTimestamp("CreateTime");
		finishTime = rest.getTimestamp("FinishTime");
		inlineNodeID = rest.getInt("InlineNodeID");
		nodeID = rest.getInt("NodeID");
		launchInfo = rest.getString("LaunchInfo");
		logIndex = rest.getInt("LogIndex");
		resultInfo = rest.getString("ResultInfo");
		operatorID = rest.getLong("OperatorID");
		userInfo = rest.getString("UserInfo");
		workitemID = rest.getLong("WorkitemID");
		workitemName = rest.getString("WorkitemName");
		workitemState = rest.getInt("WorkitemState");
		transactionID = rest.getInt("TransactionID");
		assistTransactionID = rest.getInt("assistTransactionID");
		mapCount = rest.getInt("MapCount");
		slock = rest.getInt("Slock");
	}
}
