package com.bokesoft.yigo.mid.form;

import java.nio.charset.Charset;

import com.bokesoft.yes.mid.schema.FormSchemaProvider;
import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yes.mid.schema.maintance.DBMaintanceFactory;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

public class AddMetaForm {
	private String projectKey;
	private String formKey;
	private String caption;
	private int formType;
	private String formText;
	private String filePath;
	
	public AddMetaForm(String projectKey, String formKey, String caption, int formType, String formText, String filePath) {
		super();
		this.projectKey = projectKey;
		this.formKey = formKey;
		this.caption = caption;
		this.formType = formType;
		this.formText = formText;
		this.filePath = filePath;
	}
	
	public void add(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaSolution metaSolution = metaFactory.getSolution();
				
		// 写入到文件
		IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
		resolver.write(filePath, formText.getBytes(Charset.forName("UTF-8")));
		
		MetaProject project = metaSolution.getProject(projectKey);
		MetaFormProfile profile = new MetaFormProfile();
		profile.setKey(formKey);
		profile.setCaption(caption);
		profile.setFormType(formType);
		profile.setProject(project);
		profile.setResource(filePath);
		metaFactory.getMetaFormList().add(profile);
		
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		IDBManager dbManager = context.getDBManager();
		ISchemaProvider provider = new FormSchemaProvider(metaForm);
		DBMaintanceFactory.getInstance().maintance(provider, dbManager, false);
	}
}
