package com.bokesoft.yigo.mid.event.types.meta.get.pre;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.event.types.meta.get.MetaPreGetEvent;

/**
 * 获取MetaReport前事件
 *
 * @author wangfeng
 */
public class MetaReportPreGetEvent extends MetaPreGetEvent<MetaReport> {

	/** 分组标识 */
	String group;

	/** 子列表标识 */
	String subKey;

	/** 报表标识 */
	String reportKey;

	public MetaReportPreGetEvent(IMetaFactory metaFactory, String group, String subKey, String reportKey) {
		super(metaFactory);
		this.group = group;
		this.subKey = subKey;
		this.reportKey = reportKey;
	}

	public String getGroup() {
		return group;
	}

	public String getSubKey() {
		return subKey;
	}

	public String getReportKey() {
		return reportKey;
	}
}
