package com.bokesoft.yigo.mid.event;

import com.bokesoft.yes.mid.base.EventDispatcher;
import com.bokesoft.yes.mid.event.EventDispatcherProvider;
import com.bokesoft.yes.mid.event.EventListener;
import com.bokesoft.yigo.mid.event.types.YigoEvent;

/**
 * 平台事件。
 *
 * @author wangfeng
 */
public class YigoEventFacade {

    /**
     * 注册Yigo平台事件
     * 注册监听到事件中心。监听者带的事件泛型类型，就是监听的对应事件及其子类事件类型。
     * 注意不再关注事件时需要调用{@link #unregisterListener}方法取消监听，避免内存泄露
     * 一个监听只能注册一次，多次注册会覆盖之前的注册。
     * 注册时如果使用匿名内部类，不要用lambda表达，否则无法获取事件类型。
     *
     * @param eventListener 要注册的监听对象，其接收的事件类型应为Event或其子类。
     * @throws EventDispatcher.EventRegistrationException 如果无法获取监听的事件类型，则抛出此异常。
     */
    public static void registerListener(EventListener<? extends YigoEvent> eventListener) {
        EventDispatcherProvider.getYigoEventDispatcher().register(eventListener);
    }

    /**
     * 注销Yigo平台事件
     * 取消监听的事件注册
     *
     * @param eventListener 要取消注册的监听对象，其接收的事件类型应为Event或其子类
     * @throws EventDispatcher.EventRegistrationException 如果无法获取监听的事件类型，则抛出此异常
     */
    public static void unregisterListener(EventListener<? extends YigoEvent> eventListener) {
        EventDispatcherProvider.getYigoEventDispatcher().unregister(eventListener);
    }

}
