package com.bokesoft.yigo.mid.document.io;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.SaveFilterMap;

/**
 * 访问单据数据的功能
 * 
 * @author 刘翔翔
 *
 */
public interface DocumentIO {
	/**
	 * 设置IO的标识
	 * @param key 标识
	 */
	public void setKey(String key);
	
	/**
	 * 保存指定的文档对象，其中包括前置检查、前置处理、保存、后置处理、迁移处理
	 * @param context 上下文
	 * @param saveFilterMap 保存相关的过滤设置
	 * @param document 文档对象
	 * @return 被处理后的新文档
	 * @throws Throwable 保存过程中的任何可能错误
	 */
	public Document save(DefaultContext context, SaveFilterMap saveFilterMap, Document document) throws Throwable;

	/**
	 * 删除指定的文档对象，包括迁移处理
	 * @param context 上下文
	 * @param document 文档对象
	 * @throws Throwable 删除过程中的任何可能错误
	 */
	public void delete(DefaultContext context, Document document) throws Throwable;

	/**
	 * 载入指定的实体对象，包括后期的载入处理
	 * @param context 上下文
	 * @param metaDataObject 数据对象定义
	 * @param OID 数据对象OID
	 * @return 文档对象
	 * @throws Throwable 载入过程中可能的错误
	 */
	public Document load(DefaultContext context, MetaDataObject metaDataObject, Long OID) throws Throwable;

	/**
	 * 载入数据对象，包括实体对象和普通的视图数据对象
	 * @param context 上下文
	 * @param document 存放结果的数据对象
	 * @param metaDataObject 数据对象定义
	 * @param filterMap 载入相关的过滤映射
	 * @param condParameters 条件参数
	 * @return 新文档对象
	 * @throws Throwable 载入过程中可能的错误
	 */
	public Document load(DefaultContext context, Document document, MetaDataObject metaDataObject, FilterMap filterMap, ConditionParas condParameters) throws Throwable;
	
	/**
	 * 设置数据源，这个数据的目的主要是为了让各个表单由自己的额外处理
	 * @param dataSource 数据源定义
	 */
	public void setDataSource(MetaDataSource dataSource);

}
