package com.bokesoft.yigo.mid.document;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.track.TrackDetail;

public class SaveFormData extends SaveData {
	/** 表单的标识 */
	private String formKey = "";
	
	public SaveFormData(String formKey, Document document) {
		super("", null, document);
		this.formKey = formKey;
		if (formKey != null && formKey.length() != 0) {
			document.getDocumentTrack().addTrack(TrackDetail.FROM_UI, "");
		}
	}

	public Document save(DefaultContext context) throws Throwable {
		if (formKey != null && formKey.length() != 0) {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			context.setFormKey(formKey);
			MetaDataSource metaDataSource = metaForm.getDataSource();
			metaDataObject = (MetaDataObject) metaDataSource.getDataObject();
			context.setDataObject(metaDataObject);
			document.setMetaDataObject(metaDataObject);
		}
		return super.save(context);
	}

	public MetaDataObject getDataObject(DefaultContext context) throws Throwable {
		MetaDataObject metaDataObject = null;
		if (formKey != null && formKey.length() != 0) {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			context.setFormKey(formKey);
			MetaDataSource metaDataSource = metaForm.getDataSource();
			metaDataObject = (MetaDataObject) metaDataSource.getDataObject();
			context.setDataObject(metaDataObject);
		}
		return metaDataObject;
	}
}
