package com.bokesoft.yigo.mid.document;

import com.bokesoft.yes.mid.document.impl.SaveDataImpl;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.SaveFilterMap;
import com.bokesoft.yigo.struct.document.track.TrackDetail;

/**
 * SaveData为保存数据的入口类
 * 
 * @author 王元和
 *
 */
public class SaveData {

	/** 抽象文档的配置对象 */
	protected MetaDataObject metaDataObject = null;

	/** 抽象文档的KEY */
	protected String objectKey = null;

	/** 抽象文档 */
	protected Document document = null;

	/** 保存时的数据过滤 */
	protected SaveFilterMap saveFilterMap = null;

	private SaveDataImpl impl = new SaveDataImpl();
	
	public SaveData(String objectKey, SaveFilterMap saveFilterMap, Document document) {
		this.objectKey = objectKey;
		this.document = document;
		this.saveFilterMap = saveFilterMap;
	}
	
	public SaveData(MetaDataObject metaDataObject, SaveFilterMap saveFilterMap, Document document) {
		this.metaDataObject = metaDataObject;
		this.document = document;
		this.document.setMetaDataObject(metaDataObject);
		this.saveFilterMap = saveFilterMap;
	}
	
	@Deprecated
	public Document midLaunchSave(DefaultContext context) throws Throwable {
		document.getDocumentTrack().addTrack(TrackDetail.MID_SAVE, "");
		return save(context);
	}

	public Document save(DefaultContext context) throws Throwable {
		MetaDataObject metaDataObject = document.getMetaDataObject();
		if (metaDataObject == null) {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			metaDataObject = metaFactory.getDataObject(objectKey);
			document.setMetaDataObject(metaDataObject);
		}
		context.setDataObject(metaDataObject);
		context.setDocument(document);
		
		return impl.save(context, document, saveFilterMap);
	}
}
