package com.bokesoft.yigo.mid.document;

import com.bokesoft.yes.mid.migration.process.merge.MigrationMergeProxy;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 将迁移增量表中的数据合并到迁移目标表中
 * @author wbh
 *
 */
public class MigrationMerge {
	private String dataObjectKey = null;
	private boolean isolatedTransaction = true;
	/**
	 * 构造函数
	 * @param dataObjectKey 迁移目标数据对象标识
	 * @param isolatedTransaction 是否以独立事务进行提交。True：将开启新的事务提交 False：不开启新的事务
	 */
	public MigrationMerge(String dataObjectKey, boolean isolatedTransaction) {
		this.dataObjectKey = dataObjectKey;
		this.isolatedTransaction = isolatedTransaction;
	}
	/**
	 *	将迁移增量表中的数据合并到迁移目标表中
	 * @param context 上下文
	 * @throws Throwable 合并过程中的异常
	 */
	public void merge(DefaultContext context)throws Throwable{
		MigrationMergeProxy proxy = new MigrationMergeProxy(dataObjectKey, isolatedTransaction);
		proxy.process(context);
	}
}
