package com.bokesoft.yigo.mid.document;

import com.bokesoft.yes.mid.document.impl.LoadDataImpl;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;

/**
 * 根据数据对象标识、过滤、查询条件载入数据
 * 
 * @author wangyh
 *
 */
public class LoadData {
	/** 数据对象的标识 */
	private String dataObjectKey = "";
	/** 过滤条件映射 */
	protected FilterMap filterMap = null;
	/** 查询过滤条件 */
	protected ConditionParas condParameters = null;
	
	private MetaDataObject metaDataObject = null;

	private LoadDataImpl impl = new LoadDataImpl();
	
	protected LoadData() {
	}

	/**
	 * 构造一个LoadData对象
	 * 
	 * @param dataObjectKey
	 *            数据对象标识
	 * @param filterMap
	 *            过滤条件映射
	 * @param condParameters
	 *            查询条件集合
	 */
	public LoadData(String dataObjectKey, FilterMap filterMap, ConditionParas condParameters) {
		setPara(dataObjectKey, filterMap, condParameters);
	}

	protected void setPara(String dataObjectKey, FilterMap filterMap, ConditionParas condParameters) {
		this.dataObjectKey = dataObjectKey;
		this.filterMap = filterMap;
		this.condParameters = condParameters;
	}

	/**
	 * 根据数据对象标识和数据对象ID构造一个LoadData对象
	 * 
	 * @param dataObjectKey
	 *            数据对象标识
	 * @param OID
	 *            数据对象ID
	 */
	public LoadData(String dataObjectKey, long OID) {
		this.dataObjectKey = dataObjectKey;
		filterMap = new FilterMap();
		filterMap.setOID(OID);
	}
	
	/**
	 * 根据数据对象和数据对象ID构造一个LoadData对象
	 * 
	 * @param dataObjectKey
	 *            数据对象标识
	 * @param OID
	 *            数据对象ID
	 */
	public LoadData(MetaDataObject metaDataObject, long OID) {
		this.metaDataObject = metaDataObject;
		filterMap = new FilterMap();
		filterMap.setOID(OID);
	}

	protected MetaDataObject getDataObjectKey(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject metaDataObject = metaFactory.getDataObject(this.dataObjectKey);
		return metaDataObject;
	}

	/**
	 * 载入数据
	 * 
	 * @param context
	 *            上下文
	 * @param document
	 *            初始文档
	 * @return 新文档对象
	 * @throws Throwable
	 *             载入可能中可能的错误
	 */
	public Document load(DefaultContext context, Document document) throws Throwable {
		// 取出数据源及数据对象
		if( metaDataObject == null ) {
			metaDataObject = getDataObjectKey(context);
		}
		return impl.load(context, document, filterMap, condParameters, metaDataObject);
	}

}