package com.bokesoft.yigo.mid.document;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 删除表单数据,如果删除DataObject数据,调用DeleteData
 * 
 * @author 王元和
 *
 */
public class DeleteFormData extends DeleteData {
	/** 表单的标识 */
	private String formKey = "";
	
	public DeleteFormData(String formKey, Document document) {
		super("", document);
		this.formKey = formKey;
	}

	public MetaDataObject getDataObject(DefaultContext context) throws Throwable {
		MetaDataObject metaDataObject = null;
		if (formKey != null && formKey.length() != 0) {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			context.setFormKey(formKey);
			MetaDataSource metaDataSource = metaForm.getDataSource();
			metaDataObject = metaDataSource.getDataObject();
			context.setDataObject(metaDataObject);
		}
		return metaDataObject;
	}
}
