package com.bokesoft.yigo.mid.document;

import com.bokesoft.yes.mid.document.impl.DeleteDataImpl;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

/**
 * DeleteData为删除数据的入口
 * 
 * @author 刘翔翔
 *
 */
public class DeleteData {

	/** 抽象文档的配置对象 */
	protected MetaDataObject metaDataObject = null;

	/** 抽象文档的KEY */
	protected String objectKey = null;

	/** 抽象文档 */
	private Document document = null;

	private DeleteDataImpl impl = new DeleteDataImpl();
	
	public DeleteData(String objectKey, Document document) {
		this.objectKey = objectKey;
		this.document = document;
	}
	
	public DeleteData(MetaDataObject metaDataObject, Document document) {
		this.metaDataObject = metaDataObject;
		this.document = document;
		this.document.setMetaDataObject(metaDataObject);
	}

	public MetaDataObject getDataObject(DefaultContext context) throws Throwable {
		MetaDataObject tmpDataObject = null;
		if (this.metaDataObject != null) {
			tmpDataObject = this.metaDataObject;
		} else {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			tmpDataObject = metaFactory.getDataObject(objectKey);
		}
		return tmpDataObject;
	}

	public void delete(DefaultContext context) throws Throwable {
		document.setDelete();
		this.metaDataObject = this.getDataObject(context);
		impl.delete(context, document);
	}
}
