package com.bokesoft.yigo.mid.dict.io;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.mid.dict.io.DictDBIO;
import com.bokesoft.yigo.tools.ve.VE;

/**
 * DictIO代理类， 根据注册的DictIO工厂创建DictIO
 * @see DictIOFactory
 */
@Deprecated
public class DictIOProxy  {
	/** 注册工厂类*/
	private static List<IDictIOFactory> factorys = null;
	
	private static DictIOProxy INSTANCE = new DictIOProxy();
	
	private DictIOProxy(){
		
	}
	
	/**
	 * 单例
	 * @return DictIO代理
	 */
	public static DictIOProxy getInstance(){
		return INSTANCE;
	}
	
	/**
	 * 注册DictIO工厂
	 * @param factory DictIO工厂
	 */
	public void addFactory(IDictIOFactory factory){
		if(factory != null){
			if(factorys == null){
				factorys = new ArrayList<IDictIOFactory>();
			}
			factorys.add(factory);
		}
	}
	
	/**
	 * 创建DictIO， 默认换回DictDBIO
	 * @param ve 环境变量
	 * @param itemKey 字典itemKey
	 * @return DictIO
	 */
	public IDictIO createDictIO(VE ve, String itemKey){
		IDictIO dictIO = null;
		if(factorys != null){
			for(IDictIOFactory factory : factorys){
				dictIO = factory.createDictIO(ve, itemKey);
				
				if(dictIO != null){
					return dictIO;
				}
			}
		}
		
		return new DictDBIO();
	}
	
}
