/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.util.resource.icon.css.generator;

import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontItem;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.util.resource.icon.SourceIdentifier;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.GenerateUtil;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.ICSSSourceGenerator;
import java.io.InputStream;

public class DefaultGenerator
implements ICSSSourceGenerator {
    public static final String CSS_TAG = "dflt";

    @Override
    public String getIconClassName(IMetaFactory object, MetaIconSource metaIconSource) {
        object = metaIconSource.getScene();
        return "isc-" + metaIconSource.getKey() + (object == null || ((String)object).isEmpty() ? "" : "-" + metaIconSource.getScene());
    }

    @Override
    public String generateIcon(IMetaFactory iMetaFactory, MetaIconSource metaIconSource) throws Throwable {
        String string = metaIconSource.getSource();
        StringBuilder stringBuilder = new StringBuilder();
        SourceIdentifier sourceIdentifier = SourceIdentifier.parse(string);
        String string2 = this.getIconClassName(iMetaFactory, metaIconSource);
        if (sourceIdentifier == null) {
            throw new Exception("the source definition does not comply with the rules:".concat(String.valueOf(string)));
        }
        switch (sourceIdentifier.getType()) {
            case 3: {
                stringBuilder.append(this.generateEmpty(string2));
                break;
            }
            case 0: {
                stringBuilder.append(this.generateResource(string2, iMetaFactory, sourceIdentifier.getContent(), metaIconSource.getSolutionKey()));
                break;
            }
            case 2: {
                stringBuilder.append(this.generateBase64(string2, sourceIdentifier.getContent()));
                break;
            }
            case 1: {
                stringBuilder.append(this.generateIconFont(iMetaFactory, sourceIdentifier.getContent(), string2, metaIconSource.getSolutionKey()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getTag() {
        return CSS_TAG;
    }

    protected static boolean isUnicode(String string) {
        try {
            if (string.startsWith("\\")) {
                if ((string = string.substring(1)).length() < 4) {
                    string = "0000".substring(string.length()) + string;
                }
                return Character.isValidCodePoint(Integer.parseInt(string, 16));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }

    protected String generateEmpty(String string) {
        return "." + string + "{ }";
    }

    protected String generateResource(String object, IMetaFactory iMetaFactory, String string, String string2) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".");
        stringBuilder.append((String)object);
        stringBuilder.append("{");
        stringBuilder.append("background-image:");
        stringBuilder.append("url(");
        object = iMetaFactory.loadResourceBySolutionKey("/Resource/".concat(String.valueOf(string)), string2);
        if (object == null) {
            throw new Exception("file does not exit:".concat(String.valueOf(string)));
        }
        stringBuilder.append(GenerateUtil.getBase64StrByInputStream((InputStream)object, string));
        stringBuilder.append(")");
        stringBuilder.append(";");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected String generateBase64(String string, String string2) throws Throwable {
        return "." + string + "{background-image:url(" + string2 + ");}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String generateIconFont(IMetaFactory iMetaFactory, String object, String string, String string2) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        object = ((String)object).split("\\.");
        String string3 = object[0];
        object = object[1];
        stringBuilder.append(".");
        stringBuilder.append(string);
        stringBuilder.append("{");
        stringBuilder.append("font-family:").append(string3).append(";");
        stringBuilder.append("}");
        stringBuilder.append("\r\n");
        Object object2 = null;
        if (!DefaultGenerator.isUnicode((String)object)) {
            string3 = (MetaIconFontSource)iMetaFactory.getIconFontSourceCollection().get(string3);
            if (string3 == null) throw new Exception("iconfont is not defined");
            if (iMetaFactory.loadResourceBySolutionKey("/Resource/" + string3.getSource(), string2) == null) {
                throw new Exception("file does not exit:" + string3.getSource());
            }
            iMetaFactory = (MetaIconFontItem)string3.getItemCollection().get((String)object);
            if (iMetaFactory != null) {
                object2 = iMetaFactory.getCode();
            }
        } else {
            object2 = object;
        }
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new Exception("iconfont unitcode is not defined");
        }
        stringBuilder.append(".");
        stringBuilder.append(string);
        stringBuilder.append(":before");
        stringBuilder.append("{");
        stringBuilder.append("content:\"").append((String)object2).append("\";");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

