/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.util.resource.icon;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.util.resource.icon.css.CssSourceGeneratorFactory;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.ICSSSourceGenerator;
import com.bokesoft.yigo.mid.util.resource.icon.provider.IIconSourceProvider;
import com.bokesoft.yigo.mid.util.resource.icon.provider.IconSourceProviderRegistry;
import java.util.Date;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class IconSourceUtil {
    private static String cssData;
    private static String cssClassInfo;

    public static void generateCssSource(IMetaFactory iMetaFactory) throws Throwable {
        LogSvr.getInstance().info("\u5f00\u59cb\u751f\u6210IconSource css\u6587\u4ef6");
        Date date = new Date();
        IconSourceUtil.clearFile(iMetaFactory);
        MetaIconSourceCollection metaIconSourceCollection = new MetaIconSourceCollection();
        MetaIconSourceCollection metaIconSourceCollection2 = iMetaFactory.getIconSourceCollection();
        metaIconSourceCollection.merge(metaIconSourceCollection2);
        metaIconSourceCollection2 = IconSourceUtil.getIconSourceCollectionByProvider(iMetaFactory);
        metaIconSourceCollection.merge(metaIconSourceCollection2);
        IconSourceUtil.generateCss(metaIconSourceCollection, iMetaFactory);
        long l2 = new Date().getTime() - date.getTime();
        LogSvr.getInstance().info("\u7ed3\u675f\u751f\u6210IconSource css\u6587\u4ef6\u3002\u751f\u6210\u6570\uff1a" + metaIconSourceCollection.size() + ",\u8017\u65f6\uff1a" + l2);
    }

    private static void generateCss(MetaIconSourceCollection metaIconSourceCollection, IMetaFactory iMetaFactory) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        if (metaIconSourceCollection == null) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < metaIconSourceCollection.size(); ++i2) {
            MetaIconSource metaIconSource = (MetaIconSource)metaIconSourceCollection.get(i2);
            String string = metaIconSource.getKey();
            String string2 = metaIconSource.getScene();
            String string3 = "";
            JSONObject jSONObject = new JSONObject();
            try {
                ICSSSourceGenerator iCSSSourceGenerator = CssSourceGeneratorFactory.getGenerator(string2);
                if (iCSSSourceGenerator != null) {
                    string3 = iCSSSourceGenerator.generateIcon(iMetaFactory, metaIconSource);
                    jSONObject.put("key", (Object)metaIconSource.getKey());
                    jSONObject.put("scene", (Object)metaIconSource.getScene());
                    jSONObject.put("className", (Object)iCSSSourceGenerator.getIconClassName(iMetaFactory, metaIconSource));
                    if (metaIconSource.getDisplayMode() != null) {
                        jSONObject.put("displayMode", (Object)metaIconSource.getDisplayMode());
                    }
                }
            }
            catch (Exception exception) {
                string3 = null;
                LogSvr.getInstance().error("generate failed, IconSource:" + string + " scene:" + string2, (Throwable)exception);
            }
            if (string3 == null || string3.isEmpty()) continue;
            stringBuilder.append("\r\n");
            stringBuilder.append(string3);
            jSONArray.put((Object)jSONObject);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("[class*=isc-]");
            stringBuilder.append("{");
            stringBuilder.append("background-repeat: no-repeat;");
            stringBuilder.append("background-size: cover;");
            stringBuilder.append("background-position: center center;");
            stringBuilder.append("}");
            stringBuilder.append("[class*=isc-]::before");
            stringBuilder.append("{");
            stringBuilder.append("align-items: center;");
            stringBuilder.append("justify-content: center;");
            stringBuilder.append("display: flex;");
            stringBuilder.append("height: 100%;");
            stringBuilder.append("width: 100%;");
            stringBuilder.append("}");
            cssData = stringBuilder.toString();
            cssClassInfo = jSONArray.toString();
            LogSvr.getInstance().info("IconSource\u8d44\u6e90\u5360\u7528\u5185\u5b58\u5927\u5c0f\uff1a" + cssData.getBytes().length + cssClassInfo.getBytes().length + "byte");
        }
    }

    private static void clearFile(IMetaFactory iMetaFactory) throws Throwable {
        cssData = null;
        cssClassInfo = null;
    }

    public static String getIconSourceCss(IMetaFactory iMetaFactory) throws Throwable {
        return cssData;
    }

    public static String getIconSourceClassMap(IMetaFactory iMetaFactory) throws Throwable {
        return cssClassInfo;
    }

    private static MetaIconSourceCollection getIconSourceCollectionByProvider(IMetaFactory iMetaFactory) throws Throwable {
        Map<String, IIconSourceProvider> map = IconSourceProviderRegistry.getProviders();
        MetaIconSourceCollection metaIconSourceCollection = new MetaIconSourceCollection();
        for (String string : map.keySet()) {
            if ((string = map.get(string).getIconSourceCollection(iMetaFactory)) == null) continue;
            metaIconSourceCollection.merge((MetaIconSourceCollection)string);
        }
        return metaIconSourceCollection;
    }
}

