/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.session;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.mid.session.LogOvertime;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Date;
import java.util.Iterator;

public class EvictExpiredSession {
    public void doEvict(DefaultContext defaultContext) throws Throwable {
        this.evictExpiredSessions(defaultContext, 1);
        this.evictExpiredSessions(defaultContext, 2);
        this.evictExpiredSessions(defaultContext, 0);
        this.evictExpiredOvertimeSessions(defaultContext, SessionInfoProviderHolder.getOvertimeProvider());
    }

    private void evictExpiredOvertimeSessions(DefaultContext defaultContext, ISessionInfoProvider object) throws Throwable {
        try {
            defaultContext = object.getSessionInfoMap();
            object = defaultContext.getKeys();
            int n2 = defaultContext.getTimeout();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object = defaultContext.get(string);
                if (object == null) continue;
                object = object.getType() == 1 ? object.getLastActiveTime() : object.getCreateTime();
                if (DateUtil.getNowTime().getTime() - ((Date)object).getTime() < (long)n2 * 1000L) continue;
                LogSvr.getInstance().debug("\u6e05\u7a7a\u8d85\u65f6clientID:".concat(String.valueOf(string)));
                defaultContext.remove(string);
            }
            return;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    private void evictExpiredSessions(DefaultContext defaultContext, int n2) throws Throwable {
        ISessionInfoMap iSessionInfoMap = SessionInfoProviderHolder.getProvider((int)n2).getSessionInfoMap();
        Object object = iSessionInfoMap.getKeys();
        int n3 = iSessionInfoMap.getTimeout();
        Env env = defaultContext.getVE().getEnv();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ISessionInfo iSessionInfo = iSessionInfoMap.get(string);
            if (iSessionInfo == null) continue;
            object = iSessionInfo.getType() == 1 ? iSessionInfo.getLastActiveTime() : iSessionInfo.getCreateTime();
            if (DateUtil.getNowTime().getTime() - ((Date)object).getTime() < (long)n3 * 1000L) continue;
            try {
                if (n2 != 0) {
                    env.setClientID(string);
                    env.setUserID(Long.valueOf(iSessionInfo.getOperatorID()));
                    env.setMode(iSessionInfo.getMode());
                    env.setClusterid(iSessionInfo.getClusterID());
                    new LogOvertime().doLogOvertime(defaultContext);
                    continue;
                }
                iSessionInfoMap.remove(string);
            }
            catch (Exception exception) {
                LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
                iSessionInfoMap.remove(string);
            }
        }
    }
}

