/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.report;

import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.report.IMidReportProvider;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MidReportProviderFactory {
    private static List<IMidReportProvider> midReportProviderList;

    public static void addProvider(IMidReportProvider iMidReportProvider) {
        if (midReportProviderList == null) {
            midReportProviderList = new ArrayList<IMidReportProvider>();
        }
        midReportProviderList.add(iMidReportProvider);
    }

    public static void addProviders(IMidReportProvider ... iMidReportProviderArray) {
        if (iMidReportProviderArray == null) {
            return;
        }
        if (midReportProviderList == null) {
            midReportProviderList = new ArrayList<IMidReportProvider>();
        }
        midReportProviderList.addAll(Arrays.asList(iMidReportProviderArray));
    }

    public static MetaReport getMetaReport(DefaultContext defaultContext, String string, Document document) {
        if (midReportProviderList == null) {
            return null;
        }
        MetaReport metaReport = null;
        for (IMidReportProvider iMidReportProvider : midReportProviderList) {
            if (iMidReportProvider != null) {
                try {
                    metaReport = iMidReportProvider.getMetaReport(defaultContext, string, document);
                }
                catch (Throwable throwable) {
                    LogSvr.getInstance().error("MidReportProviderFactory getMetaReport", throwable);
                }
            }
            if (metaReport == null) continue;
        }
        return metaReport;
    }
}

