/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.servicerights;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.servicerights.IServiceRights;
import com.bokesoft.yes.mid.servicerights.Permission;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRightsImpl
implements IServiceRights {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRightsImpl.class);

    @Override
    public void saveServiceRights(DefaultContext defaultContext, long l2, String string, String string2) throws Throwable {
        if (!this.checkParas(l2, string, string2)) {
            throw new RuntimeException("Input paras is null or invalid! ");
        }
        if (StringUtil.isEmptyStr((String)(string = this.getTableName(string)))) {
            throw new RuntimeException(" tableName is null or invalid! ");
        }
        string2 = new JSONArray(string2);
        this.saveTable(defaultContext, l2, defaultContext.getDBManager(), (JSONArray)string2, string);
    }

    private boolean checkParas(long l2, String string, String string2) throws Throwable {
        if (l2 <= 0L) {
            return false;
        }
        logger.info("checkParas().type:" + string + ", jsonRights:" + string2);
        if (StringUtil.isEmptyStr((String)string) || !"operator".equals(string) && !"role".equals(string)) {
            throw new RuntimeException("Input type is null or invalid! ");
        }
        if (StringUtil.isEmptyStr((String)string2)) {
            throw new RuntimeException("Input jsonRights is null or invalid! ");
        }
        JSONArray jSONArray = new JSONArray(string2);
        if (jSONArray.length() <= 0 || jSONArray.getJSONObject(0) == null || jSONArray.getJSONObject(0).isNull("ServiceID")) {
            throw new RuntimeException("Input jsonRights is null or invalid! ");
        }
        return true;
    }

    @Override
    public Permission getServiceRights(DefaultContext defaultContext, long l2, String object) throws Throwable {
        logger.info("getServiceRights().id:" + l2 + ", type:" + (String)object);
        Permission permission = new Permission();
        if ("operator".equals(object)) {
            this.getOperatorRights(defaultContext, l2, permission, null);
            logger.debug("getServiceRights().permi.getOperatorRights():" + permission.getOperatorRights().toString());
        } else if ("role".equals(object)) {
            object = new ArrayList<Long>();
            object.add(l2);
            this.getRolesRights(defaultContext, (List<Long>)object, permission);
            logger.debug("getServiceRights().permi.getRolesRights():" + permission.getRolesRights().toString());
        } else {
            throw new RuntimeException("Input type is null or invalid! ");
        }
        return permission;
    }

    @Override
    public Permission getServiceRights(DefaultContext defaultContext, ISessionInfo object, String string) throws Throwable {
        if (StringUtil.isEmptyStr((String)string)) {
            return this.getServiceRights(defaultContext, (ISessionInfo)object);
        }
        Permission permission = new Permission();
        long l2 = object.getOperatorID();
        if (l2 > 0L) {
            this.getOperatorRights(defaultContext, l2, permission, string);
            return permission;
        }
        if ((object = object.getRoleIDList()) != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
            this.getRolesRights(defaultContext, (List<Long>)object, permission, string);
        }
        return permission;
    }

    private Permission getServiceRights(DefaultContext defaultContext, ISessionInfo object) throws Throwable {
        Permission permission = new Permission();
        long l2 = object.getOperatorID();
        if (l2 > 0L) {
            this.getOperatorRights(defaultContext, l2, permission, null);
        }
        if ((object = object.getRoleIDList()) != null && ((ArrayList)object).size() > 0) {
            this.getRolesRights(defaultContext, (List<Long>)object, permission);
        }
        return permission;
    }

    private void getOperatorRights(DefaultContext object, long l2, Permission permission, String string) throws Throwable {
        String string2 = "select ServiceID, Owner, Enable, Opts from Sys_OperatorServiceRights where OperatorID = ? ";
        String string3 = " and ServiceID = ? ";
        permission.setOperatorID(l2);
        if (string != null) {
            string2 = string2 + string3;
        }
        object = object.getDBManager().preparedQueryStatement(string2);
        object.setLong(1, l2);
        if (string != null) {
            object.setString(2, string);
        }
        ResultSet resultSet = object.executeQuery();
        JSONArray jSONArray = this.resultSet2Json(resultSet);
        logger.debug("getOperatorRight():" + jSONArray.toString());
        permission.setOperatorRights(jSONArray);
        this.closeRs(resultSet);
        this.closePs((PreparedStatement)object);
    }

    private JSONArray resultSet2Json(ResultSet resultSet) throws Throwable {
        JSONArray jSONArray = new JSONArray();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            JSONObject jSONObject = new JSONObject();
            for (int i2 = 1; i2 <= n2; ++i2) {
                String string = resultSetMetaData.getColumnLabel(i2);
                String string2 = resultSet.getString(string);
                jSONObject.put(string, (Object)string2);
            }
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    private void getRolesRights(DefaultContext object, List<Long> list, Permission permission) throws Throwable {
        String string = "select ServiceID, Owner, Enable, Opts from Sys_RoleServiceRights where RoleID = ? ";
        HashMap<Long, JSONArray> hashMap = new HashMap<Long, JSONArray>();
        ResultSet resultSet = null;
        object = object.getDBManager().preparedQueryStatement(string);
        for (int i2 = 0; i2 <= list.size() - 1; ++i2) {
            long l2 = list.get(i2);
            object.setLong(1, l2);
            resultSet = object.executeQuery();
            JSONArray jSONArray = this.resultSet2Json(resultSet);
            hashMap.put(l2, jSONArray);
        }
        permission.setRolesRights(hashMap);
        this.closeRs(resultSet);
        this.closePs((PreparedStatement)object);
    }

    private void getRolesRights(DefaultContext object, List<Long> list, Permission permission, String string) throws Throwable {
        String string2 = "select ServiceID, Owner, Enable, Opts from Sys_RoleServiceRights where RoleID = ? and ServiceID = ? ";
        HashMap<Long, JSONArray> hashMap = new HashMap<Long, JSONArray>();
        ResultSet resultSet = null;
        object = object.getDBManager().preparedQueryStatement(string2);
        for (int i2 = 0; i2 <= list.size() - 1; ++i2) {
            long l2 = list.get(i2);
            object.setLong(1, l2);
            object.setString(2, string);
            resultSet = object.executeQuery();
            JSONArray jSONArray = this.resultSet2Json(resultSet);
            hashMap.put(l2, jSONArray);
        }
        permission.setRolesRights(hashMap);
        this.closeRs(resultSet);
        this.closePs((PreparedStatement)object);
    }

    @Override
    public boolean hasServiceRight(Permission object, String string) {
        if (object == null || StringUtil.isEmptyStr((String)string)) {
            return false;
        }
        boolean bl = false;
        JSONArray jSONArray = ((Permission)object).getOperatorRights();
        logger.debug("hasServiceRight().permi.operatorRights:".concat(String.valueOf(jSONArray)));
        object = ((Permission)object).getRolesRights();
        if (jSONArray.length() > 0) {
            bl = this.hasOperatorRight(jSONArray, string);
        }
        if (!bl && !object.isEmpty()) {
            bl = this.hasRolesRight((Map<Long, JSONArray>)object, string);
        }
        return bl;
    }

    private boolean hasOperatorRight(JSONArray jSONArray, String string) {
        for (int i2 = 0; i2 <= jSONArray.length() - 1; ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (!string.equals(jSONObject.get("ServiceID"))) continue;
            return true;
        }
        return false;
    }

    private boolean hasRolesRight(Map<Long, JSONArray> object, String string) {
        for (JSONArray jSONArray : object.values()) {
            for (int i2 = 0; i2 <= jSONArray.length() - 1; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                if (!string.equals(jSONObject.get("ServiceID"))) continue;
                return true;
            }
        }
        return false;
    }

    private void saveTable(DefaultContext object, long l2, IDBManager iDBManager, JSONArray jSONArray, String string) throws Throwable {
        Statement statement;
        Statement statement2;
        block32: {
            Object object2;
            if (StringUtil.isEmptyStr((String)string) || jSONArray == null || jSONArray.length() <= 0) {
                return;
            }
            object = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<String> arrayList4 = this.getConditionFieldsList(string);
            Iterator iterator = jSONArray.getJSONObject(0).keys();
            int n2 = 0;
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                if ("RowState".equals(object2)) continue;
                arrayList.add((String)object2);
                arrayList3.add(n2);
                if (!"ServiceID".equals(object2)) {
                    ((ArrayList)object).add(object2);
                    arrayList2.add(n2);
                }
                ++n2;
            }
            ((ArrayList)object).add("Enable");
            ArrayList<Integer> arrayList5 = arrayList2;
            arrayList5.add(arrayList5.size());
            arrayList.add("Enable");
            ArrayList<Integer> arrayList6 = arrayList3;
            arrayList6.add(arrayList6.size());
            this.setInsertFieldsList(string, arrayList);
            ArrayList<Integer> arrayList7 = arrayList3;
            arrayList7.add(arrayList7.size());
            logger.debug("insertFieldList:" + arrayList.toString());
            logger.debug("insertKeyIndex:" + arrayList3.toString());
            object2 = null;
            int n3 = 0;
            statement2 = null;
            int n4 = 0;
            statement = null;
            int n5 = 0;
            String string2 = null;
            try {
                for (int i2 = 0; i2 <= jSONArray.length() - 1; ++i2) {
                    Object object3;
                    JSONObject jSONObject;
                    String string3 = jSONArray.getJSONObject(i2).get("RowState").toString();
                    if (Integer.parseInt(string3) == 3) {
                        if (object2 == null) {
                            string2 = DBUtil.getDeleteSQL((IDBManager)iDBManager, (String)string, arrayList4);
                            logger.debug("ServiceRightsImpl..delete sql:".concat(String.valueOf(string2)));
                            object2 = iDBManager.preparedUpdateStatement(string2);
                        }
                        int n6 = 1;
                        for (String string4 : arrayList4) {
                            if ("OperatorID".equals(string4) || "RoleID".equals(string4)) {
                                iDBManager.setParameter((PreparedStatement)object2, n6++, (Object)l2, 1002);
                                continue;
                            }
                            iDBManager.setParameter((PreparedStatement)object2, n6++, jSONArray.getJSONObject(i2).get(string4), 1002);
                        }
                        if (SvrInfo.isNeedDebug()) {
                            LogSvr.getInstance().debug(string2);
                        }
                        object2.addBatch();
                        if (++n3 != 100) continue;
                        object2.executeBatch();
                        n3 = 0;
                        continue;
                    }
                    if (Integer.parseInt(string3) == 2) {
                        if (statement2 == null) {
                            string2 = DBUtil.getUpdateSQL((IDBManager)iDBManager, (String)string, (ArrayList)object, null, arrayList4);
                            logger.debug("ServiceRightsImpl..update sql:".concat(String.valueOf(string2)));
                            statement2 = iDBManager.preparedUpdateStatement(string2);
                        }
                        if (SvrInfo.isNeedDebug()) {
                            LogSvr.getInstance().debug(string2);
                        }
                        int n7 = 1;
                        jSONObject = jSONArray.getJSONObject(i2);
                        Iterator iterator2 = arrayList2.iterator();
                        while (iterator2.hasNext()) {
                            int n6 = (Integer)iterator2.next();
                            object3 = (String)((ArrayList)object).get(n6);
                            if ("Enable".equals(object3)) {
                                object3 = "1";
                            } else {
                                if ("OperatorID".equals(object3) || "RoleID".equals(object3)) {
                                    iDBManager.setParameter((PreparedStatement)statement2, n7++, (Object)l2, 1010);
                                    continue;
                                }
                                object3 = jSONObject.get((String)object3);
                            }
                            iDBManager.setParameter((PreparedStatement)statement2, n7++, object3, 1002);
                        }
                        iDBManager.setParameter((PreparedStatement)statement2, n7++, (Object)jSONArray.getJSONObject(i2).get("ServiceID").toString(), 1002);
                        iDBManager.setParameter((PreparedStatement)statement2, n7, (Object)l2, 1002);
                        statement2.addBatch();
                        if (++n4 != 100) continue;
                        statement2.executeBatch();
                        n4 = 0;
                        continue;
                    }
                    if (Integer.parseInt(string3) != 1) continue;
                    int n9 = 1;
                    if (statement == null) {
                        string2 = DBUtil.getInsertSQL((IDBManager)iDBManager, (String)string, arrayList);
                        logger.debug("ServiceRightsImpl..inert sql:".concat(String.valueOf(string2)));
                        statement = iDBManager.preparedUpdateStatement(string2);
                    }
                    if (SvrInfo.isNeedDebug()) {
                        LogSvr.getInstance().debug(string2);
                    }
                    jSONObject = jSONArray.getJSONObject(i2);
                    Iterator iterator3 = arrayList3.iterator();
                    while (iterator3.hasNext()) {
                        int n7 = (Integer)iterator3.next();
                        object3 = arrayList.get(n7);
                        if ("Enable".equals(object3)) {
                            object3 = "1";
                        } else {
                            if ("OperatorID".equals(object3) || "RoleID".equals(object3)) {
                                iDBManager.setParameter((PreparedStatement)statement, n9++, (Object)l2, 1010);
                                continue;
                            }
                            object3 = jSONObject.get((String)object3);
                        }
                        iDBManager.setParameter((PreparedStatement)statement, n9++, object3, 1002);
                    }
                    statement.addBatch();
                    if (++n5 != 100) continue;
                    statement.executeBatch();
                    n5 = 0;
                }
                if (object2 != null && n3 > 0) {
                    object2.executeBatch();
                }
                if (statement2 != null && n4 > 0) {
                    statement2.executeBatch();
                }
                if (statement != null && n5 > 0) {
                    statement.executeBatch();
                }
                if (object2 == null) break block32;
            }
            catch (Throwable throwable) {
                if (object2 != null) {
                    object2.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            object2.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }

    private ArrayList<String> getConditionFieldsList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ServiceID");
        if ("Sys_OperatorServiceRights".equals(string)) {
            arrayList.add("OperatorID");
        } else if ("Sys_RoleServiceRights".equals(string)) {
            arrayList.add("RoleID");
        } else {
            return null;
        }
        return arrayList;
    }

    private void setInsertFieldsList(String string, ArrayList<String> arrayList) {
        if ("Sys_OperatorServiceRights".equals(string)) {
            arrayList.add("OperatorID");
            return;
        }
        if ("Sys_RoleServiceRights".equals(string)) {
            arrayList.add("RoleID");
            return;
        }
    }

    private String getTableName(String string) {
        String string2 = null;
        if ("operator".equals(string)) {
            string2 = "Sys_OperatorServiceRights";
        } else if ("role".equals(string)) {
            string2 = "Sys_RoleServiceRights";
        }
        return string2;
    }

    public boolean inWhiteList(DefaultContext object, String string) throws Throwable {
        boolean bl = false;
        Object object2 = "select ServiceID from Sys_ServiceWhiteList ";
        object = object.getDBManager().preparedQueryStatement((String)object2);
        object2 = object.executeQuery();
        while (object2.next()) {
            String string2 = object2.getString("ServiceID");
            if (string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        this.closeRs((ResultSet)object2);
        this.closePs((PreparedStatement)object);
        return bl;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                return;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private void closePs(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
                return;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private void saveRoleRights(BaseContext baseContext, long l2, String batchPsPara3, String string) throws Throwable {
        Object object;
        batchPsPara3 = "select ServiceID from Sys_RoleServiceRights where RoleID = ? ";
        Object object2 = "delete from Sys_RoleServiceRights where RoleID = ? and ServiceID = ?";
        String string2 = "insert into Sys_RoleServiceRights (RoleID, ServiceID, Owner, Enable, Opts) values (?,?,?,?,?)";
        batchPsPara3 = baseContext.getDBManager().preparedQueryStatement((String)batchPsPara3);
        batchPsPara3.setLong(1, l2);
        batchPsPara3 = batchPsPara3.executeQuery();
        Object object3 = new ArrayList<String>();
        while (batchPsPara3.next()) {
            object3.add(batchPsPara3.getString(0));
        }
        if (object3.size() > 0) {
            batchPsPara3 = new BatchPsPara((String)object2);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object3 = (String)object2.next();
                object = new PSArgs();
                object.addLongArg(Long.valueOf(l2));
                object.addStringArg((String)object3);
                batchPsPara3.putArgs((PSArgs)object);
            }
            baseContext.getDBManager().executeUpdate(batchPsPara3);
        }
        batchPsPara3 = new ArrayList();
        object2 = new JSONArray(string);
        for (int i2 = 0; i2 <= object2.length() - 1; ++i2) {
            object = object2.getJSONObject(i2);
            batchPsPara3.add(object);
        }
        if (batchPsPara3.size() > 0) {
            BatchPsPara batchPsPara2 = new BatchPsPara(string2);
            for (BatchPsPara batchPsPara3 : batchPsPara3) {
                string = new PSArgs();
                string.addLongArg(Long.valueOf(l2));
                string.addStringArg(batchPsPara3.getString("ServiceID"));
                string.addStringArg(batchPsPara3.getString("Owner"));
                string.addStringArg("1");
                string.addStringArg(batchPsPara3.getString("Opts"));
                batchPsPara2.putArgs((PSArgs)string);
            }
            baseContext.getDBManager().executeUpdate(batchPsPara2);
        }
    }

    private void saveOperatorRights(BaseContext baseContext, long l2, String batchPsPara3, String string) throws Throwable {
        Object object;
        batchPsPara3 = "select ServiceID from Sys_OperatorServiceRights where OperatorID = ? ";
        Object object2 = "delete from Sys_OperatorServiceRights where OperatorID = ? and ServiceID = ?";
        String string2 = "insert into Sys_OperatorServiceRights (OperatorID, ServiceID, Owner, Enable, Opts) values (?,?,?,?,?)";
        batchPsPara3 = baseContext.getDBManager().preparedQueryStatement((String)batchPsPara3);
        batchPsPara3.setLong(1, l2);
        batchPsPara3 = batchPsPara3.executeQuery();
        Object object3 = new ArrayList<String>();
        while (batchPsPara3.next()) {
            object3.add(batchPsPara3.getString(0));
        }
        if (object3.size() > 0) {
            batchPsPara3 = new BatchPsPara((String)object2);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object3 = (String)object2.next();
                object = new PSArgs();
                object.addLongArg(Long.valueOf(l2));
                object.addStringArg((String)object3);
                batchPsPara3.putArgs((PSArgs)object);
            }
            baseContext.getDBManager().executeUpdate(batchPsPara3);
        }
        batchPsPara3 = new ArrayList();
        object2 = new JSONArray(string);
        for (int i2 = 0; i2 <= object2.length() - 1; ++i2) {
            object = object2.getJSONObject(i2);
            batchPsPara3.add(object);
        }
        if (batchPsPara3.size() > 0) {
            BatchPsPara batchPsPara2 = new BatchPsPara(string2);
            for (BatchPsPara batchPsPara3 : batchPsPara3) {
                string = new PSArgs();
                string.addLongArg(Long.valueOf(l2));
                string.addStringArg(batchPsPara3.getString("ServiceID"));
                string.addStringArg(batchPsPara3.getString("Owner"));
                string.addStringArg("1");
                string.addStringArg(batchPsPara3.getString("Opts"));
                batchPsPara2.putArgs((PSArgs)string);
            }
            baseContext.getDBManager().executeUpdate(batchPsPara2);
        }
    }

    public static void main(String[] object) {
        object = "[{\"A\":\"a1\",\"B\":\"b1\",\"C\":\"c1\"},{\"A\":\"a2\",\"B\":\"b2\",\"C\":\"c2\"},{\"A\":\"a3\",\"B\":\"b3\",\"C\":\"c3\"}]";
        if ((object = new JSONArray((String)object)).length() <= 0 || object.getJSONObject(0) == null || object.getJSONObject(0).isNull("ServiceID")) {
            System.out.println("ServiceID is null1");
        }
        System.out.println("jarr not null! jarr:" + object.toString());
        System.out.println("jarr.length():" + object.length());
        System.out.println("jarr.toString():" + object.toString());
        Object object2 = object.getJSONObject(0).get("B").toString();
        System.out.println("B:".concat(String.valueOf(object2)));
        object2 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        object = object.getJSONObject(0).keys();
        int n2 = 1;
        while (object.hasNext()) {
            String string = (String)object.next();
            arrayList.add(string);
            arrayList3.add(n2);
            if (!"C".equals(string)) {
                ((ArrayList)object2).add(string);
                arrayList2.add(n2);
            }
            ++n2;
        }
        System.out.println("insertFieldList:" + arrayList.toString());
        System.out.println("insertKeyIndex:" + arrayList3.toString());
        System.out.println("updateFieldList:" + ((AbstractCollection)object2).toString());
        System.out.println("updateKeyIndex:" + arrayList2.toString());
    }
}

