/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.doc;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.io.doc.DocLockCheck;
import com.bokesoft.yes.mid.io.doc.d;
import com.bokesoft.yes.mid.relation.RelationProxy;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaSecurityProvider;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.extend.ISecurityProvider;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.SaveFilterMap;
import com.bokesoft.yigo.struct.document.TableSaveFilterDetail;
import com.bokesoft.yigo.tools.ve.VE;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DocSave {
    private Document doc = null;
    private MetaDataObject metaDataObject = null;
    private SaveFilterMap saveFilterMap = null;
    private MetaTable mainTable = null;
    private Integer VERID = 0;
    private static Map<MetaTable, d> structs = new HashMap<MetaTable, d>();

    public DocSave(Document document, SaveFilterMap saveFilterMap, MetaDataObject metaDataObject) {
        this.doc = document;
        this.metaDataObject = metaDataObject;
        this.saveFilterMap = saveFilterMap;
        this.mainTable = metaDataObject.getMainTable();
        this.VERID = document.getVERID();
    }

    public boolean save(DefaultContext defaultContext) throws Throwable {
        IDBManager iDBManager = defaultContext.getDBManager();
        MidVE midVE = defaultContext.getVE();
        MetaSecurityFilter metaSecurityFilter = midVE.getMetaFactory().getSecurityFilter(null);
        if (metaSecurityFilter != null) {
            metaSecurityFilter = metaSecurityFilter.getRelationproxy();
            String string = metaSecurityFilter.getImpl();
            ((RelationProxy)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)string)).checkDoc((VE)midVE, iDBManager, this.doc, 2, metaSecurityFilter.isCache().booleanValue());
        }
        this.check(defaultContext);
        this.saveDiret(defaultContext, iDBManager);
        return true;
    }

    private void check(DefaultContext defaultContext) throws Throwable {
        IDBManager iDBManager = defaultContext.getDBManager();
        MidVE midVE = defaultContext.getVE();
        this.preSecurityCheck((VE)midVE);
        DocLockCheck.checkAndLock((ILocale)defaultContext.getEnv(), this.doc, this.metaDataObject, iDBManager);
        midVE = this.metaDataObject.getMainTable();
        if (midVE != null && midVE.isUniquePrimary().booleanValue()) {
            this.preCheck4UniquePrimary(iDBManager, this.doc.get(midVE.getKey()), (MetaTable)midVE);
        }
        AuthorityCheckUtil.checkBeforeSave((DefaultContext)defaultContext);
    }

    private void preSecurityCheck(VE vE) throws Throwable {
        Object object = this.metaDataObject.getSecurityProviderCollection();
        if (object != null && (object = (MetaSecurityProvider)object.get("Save")) != null && (object = object.getProvider()) != null && !((String)object).isEmpty() && (object = (ISecurityProvider)ReflectHelper.newInstance((VE)vE, (String)object)) != null) {
            object.doCheck(vE, this.metaDataObject.getKey(), this.doc);
        }
    }

    public void saveDiret(DefaultContext defaultContext, IDBManager iDBManager) throws Throwable {
        TraceRecorder.traceData((String)"docSave", (Object)this.doc);
        if (this.mainTable != null) {
            Iterator iterator = this.doc.get(this.mainTable.getKey());
            if (this.metaDataObject.getSecondaryType() == 6 || this.metaDataObject.getSecondaryType() == 8) {
                this.saveTable(defaultContext, iDBManager, (DataTable)iterator, this.mainTable);
            } else if (this.doc.getDocumentType() == 1) {
                if (iterator.getState(0) != 0) {
                    this.saveTable(defaultContext, iDBManager, (DataTable)iterator, this.mainTable);
                }
                this.doc.reSetIDValue();
            } else if (this.doc.getDocumentType() == 2) {
                DocSave.saveMainTableVersionID((DataTable)iterator, this.mainTable, iDBManager, this.doc.getOID(), false);
            }
        }
        for (MetaTable metaTable : this.metaDataObject.getTableCollection()) {
            if (metaTable == this.mainTable || metaTable.isHidden().booleanValue()) continue;
            this.saveTable(defaultContext, iDBManager, this.doc.get(metaTable.getKey()), metaTable);
        }
        this.sortDataTable();
    }

    private void sortDataTable() throws Throwable {
        for (MetaTable metaTable : this.metaDataObject.getTableCollection()) {
            Object object;
            if (metaTable.getSequenceColumn() != null || (object = metaTable.getSortColumns()).isEmpty() || (metaTable = this.doc.get(metaTable.getKey())) == null || metaTable.size() <= 1) continue;
            SortCriteria[] sortCriteriaArray = new SortCriteria[object.size()];
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                MetaColumn metaColumn = (MetaColumn)object.next();
                metaColumn = new SortCriteria(metaColumn.getKey(), metaColumn.getSort() == 1);
                sortCriteriaArray[n2] = metaColumn;
                ++n2;
            }
            metaTable.setSort(sortCriteriaArray);
            metaTable.sort();
        }
    }

    private void preCheck4UniquePrimary(IDBManager iDBManager, DataTable dataTable, MetaTable object) throws Throwable {
        Object object2;
        block15: {
            Object object3;
            Object object4;
            block13: {
                block14: {
                    if (dataTable == null || dataTable.size() == 0) {
                        return;
                    }
                    if (dataTable.getState(0) == 0) {
                        return;
                    }
                    object2 = object.getOIDColumn().getBindingDBColumnName();
                    object4 = object.getBindingDBTableName();
                    iDBManager.setRowLock((String)object4, (String)object2, Long.valueOf(-1L));
                    object3 = new ArrayList<MetaTable>();
                    PSArgs pSArgs = new ArrayList();
                    Iterator iterator = object.entryIterator();
                    while (iterator.hasNext()) {
                        object = (MetaColumn)((Map.Entry)iterator.next()).getValue();
                        if (!object.getIsPrimary().booleanValue()) continue;
                        ((ArrayList)object3).add(object);
                        pSArgs.add(object.getBindingDBColumnName());
                    }
                    object = new ArrayList<String>();
                    object.add(object2);
                    object = DBUtil.getQuerySQL((IDBManager)iDBManager, (ArrayList)object, (String)object4, pSArgs);
                    object2 = null;
                    object4 = null;
                    try {
                        object2 = iDBManager.preparedQueryStatement((String)object);
                        pSArgs = new PSArgs();
                        object3 = ((ArrayList)object3).iterator();
                        while (object3.hasNext()) {
                            iterator = (MetaColumn)object3.next();
                            pSArgs.addArg(iterator.getDataType(), dataTable.getObject(0, iterator.getKey()));
                        }
                        object4 = iDBManager.executeQuery((PreparedStatement)object2, (String)object, (QueryArguments)pSArgs);
                        if (object4.next()) break block13;
                        if (object4 == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (object4 != null) {
                            object4.close();
                        }
                        if (object2 != null) {
                            object2.close();
                        }
                        throw throwable;
                    }
                    object4.close();
                }
                if (object2 != null) {
                    object2.close();
                }
                return;
            }
            if (dataTable.getState(0) == 1) {
                throw new MidCoreException(14, MidCoreException.formatMessage(null, (int)14, (Object[])new Object[0]));
            }
            object3 = TypeConvertor.toLong((Object)dataTable.getObject(0, "OID"));
            if (!Long.valueOf(object4.getLong(1)).equals(object3) || object4.next()) {
                throw new MidCoreException(14, MidCoreException.formatMessage(null, (int)14, (Object[])new Object[0]));
            }
            if (object4 == null) break block15;
            object4.close();
        }
        if (object2 != null) {
            object2.close();
            return;
        }
    }

    private final void saveTable(DefaultContext object, IDBManager objectArray, DataTable dataTable, MetaTable metaTable) throws Throwable {
        Statement statement;
        Statement statement2;
        Statement statement3;
        block35: {
            Object object2 = this.saveFilterMap != null ? (TableSaveFilterDetail)this.saveFilterMap.get((Object)metaTable.getKey()) : null;
            if (object2 != null && object2.getSaveType() == 2) {
                return;
            }
            if (dataTable == null) {
                return;
            }
            if (!metaTable.isPersist().booleanValue()) {
                return;
            }
            object2 = metaTable.getBindingDBTableName();
            if (objectArray.saveDataTable(dataTable, (String)object2, metaTable, (Object)this.doc)) {
                return;
            }
            dataTable.setShowDeleted(true);
            if (metaTable.getOIDColumn() == null) {
                throw new MidCoreException(41, MidCoreException.formatMessage(null, (int)41, (Object[])new Object[]{metaTable.getKey()}));
            }
            object2 = structs.get(metaTable);
            if (object2 == null) {
                object2 = new d((DefaultContext)object, metaTable, dataTable.getMetaData());
                structs.put(metaTable, (d)object2);
            }
            object = new ArrayList();
            String string = null;
            Statement statement4 = null;
            statement3 = null;
            int n2 = 0;
            statement2 = null;
            int n3 = 0;
            statement = null;
            int n4 = 0;
            Object object3 = null;
            int[] nArray = object2.c;
            ColumnInfo[] columnInfoArray = object2.a;
            try {
                Object object4;
                int n5;
                int n6;
                Object object5;
                Object object6;
                dataTable.beforeFirst();
                while (dataTable.next()) {
                    Object object7;
                    int n7;
                    int n8 = dataTable.getState();
                    if (n8 == 3) {
                        ((ArrayList)object).add(dataTable.getBookmark());
                        if (statement3 == null) {
                            String string2 = metaTable.getOIDColumn().getBindingDBColumnName();
                            object3 = DBUtil.getDeleteSQL((IDBManager)objectArray, (String)metaTable.getBindingDBTableName(), (String)string2);
                            statement3 = objectArray.preparedUpdateStatement((String)object3);
                        }
                        objectArray.setParameter((PreparedStatement)statement3, 1, (Object)TypeConvertor.toLong((Object)dataTable.getObject("OID")), 1010);
                        if (SvrInfo.isNeedDebug()) {
                            LogSvr.getInstance().debug((String)object3);
                        }
                        statement3.addBatch();
                        if (++n2 != 100) continue;
                        statement3.executeBatch();
                        n2 = 0;
                        continue;
                    }
                    if (n8 == 2) {
                        ((ArrayList)object).add(dataTable.getBookmark());
                        if (statement2 == null) {
                            object6 = objectArray;
                            object3 = object2;
                            if (object3.t == null) {
                                String string3 = object3.a.getOIDColumn().getBindingDBColumnName();
                                object5 = object3.a.getVERIDColumn().getBindingDBColumnName();
                                object3.t = DBUtil.getUpdateSQL((IDBManager)object6, (String)object3.a.getBindingDBTableName(), object3.i, (String)object5, (String)string3);
                            }
                            object3 = object3.t;
                            statement2 = objectArray.preparedUpdateStatement((String)object3);
                        }
                        if (SvrInfo.isNeedDebug()) {
                            LogSvr.getInstance().debug((String)object3);
                        }
                        n8 = 1;
                        object6 = dataTable.impl_getRow();
                        object5 = object2.a;
                        n7 = object2.a.length;
                        for (n6 = 0; n6 < n7; ++n6) {
                            n5 = object5[n6];
                            object7 = object6[n5];
                            object7 = this.convertValue(object7, nArray[n5], columnInfoArray[n5]);
                            objectArray.setParameter((PreparedStatement)statement2, n8++, object7, nArray[n5]);
                        }
                        objectArray.setParameter((PreparedStatement)statement2, n8, (Object)TypeConvertor.toLong((Object)dataTable.getObject("OID")), 1010);
                        dataTable.setInt("VERID", Integer.valueOf(TypeConvertor.toInteger((Object)dataTable.getObject("VERID")) + 1));
                        statement2.addBatch();
                        if (++n3 != 100) continue;
                        statement2.executeBatch();
                        n3 = 0;
                        continue;
                    }
                    if (n8 != 1) continue;
                    n8 = 1;
                    if (statement == null) {
                        object6 = objectArray;
                        object3 = object2;
                        if (object3.s == null) {
                            object3.s = DBUtil.getInsertSQL((IDBManager)object6, (String)object3.a.getBindingDBTableName(), object3.j);
                        }
                        object3 = object3.s;
                        statement = objectArray.preparedUpdateStatement((String)object3);
                    }
                    if (SvrInfo.isNeedDebug()) {
                        LogSvr.getInstance().debug((String)object3);
                    }
                    object6 = dataTable.impl_getRow();
                    object5 = object2.b;
                    n7 = object2.b.length;
                    for (n6 = 0; n6 < n7; ++n6) {
                        n5 = object5[n6];
                        object7 = object6[n5];
                        object7 = this.convertValue(object7, nArray[n5], columnInfoArray[n5]);
                        objectArray.setParameter((PreparedStatement)statement, n8++, object7, nArray[n5]);
                    }
                    statement.addBatch();
                    if (++n4 != 100) continue;
                    statement.executeBatch();
                    n4 = 0;
                }
                if (statement3 != null && n2 > 0) {
                    statement3.executeBatch();
                }
                if (statement2 != null && n3 > 0) {
                    statement2.executeBatch();
                }
                if (statement != null && n4 > 0) {
                    statement.executeBatch();
                }
                if ((object4 = this.metaDataObject.getHistory()) != null && object4.isSupport().booleanValue()) {
                    object4 = ((ArrayList)object).iterator();
                    while (object4.hasNext()) {
                        object6 = (Integer)object4.next();
                        dataTable.setBookmark(((Integer)object6).intValue());
                        object5 = new PSArgs();
                        int[] nArray2 = object2.b;
                        n6 = object2.b.length;
                        for (n5 = 0; n5 < n6; ++n5) {
                            int n9 = nArray2[n5];
                            object = dataTable.getMetaData().getColumnInfo(n9).getColumnKey();
                            if ("VERID".equalsIgnoreCase((String)object)) continue;
                            object = dataTable.getOriginalObject(n9);
                            object5.addArg(Integer.valueOf(dataTable.getMetaData().getColumnInfo(n9).getDataType()), object);
                        }
                        object5.addArg(Integer.valueOf(1001), dataTable.getOriginalObject("VERID"));
                        object5.addArg(Integer.valueOf(1001), (Object)this.VERID);
                        if (statement4 == null) {
                            string = DBUtil.getHistoryInsertSQL((IDBManager)objectArray, (String)metaTable.getHistoryTableName(), object2.j);
                            statement4 = objectArray.preparedUpdateStatement(string);
                        }
                        objectArray.executeUpdate((PreparedStatement)statement4, string, (QueryArguments)object5);
                    }
                }
                if (statement4 == null) break block35;
            }
            catch (Throwable throwable) {
                if (statement4 != null) {
                    statement4.close();
                }
                if (statement3 != null) {
                    statement3.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            statement4.close();
        }
        if (statement3 != null) {
            statement3.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }

    protected Object convertValue(Object object, int n2, ColumnInfo columnInfo) {
        if (StringUtil.isBlankOrNull((Object)object)) {
            if (n2 == 1002 || n2 == 1012 || n2 == 1011) {
                object = "  ";
            } else if (n2 == 1001) {
                object = 0;
            } else if (n2 == 1010) {
                object = 0L;
            } else if (n2 == 1006 || n2 == 1005 || n2 == 1007) {
                object = BigDecimal.ZERO;
            }
        } else if (n2 == 1002 || n2 == 1012 || n2 == 1011) {
            n2 = columnInfo.getCaseType();
            if (1 == n2) {
                object = ((String)object).toLowerCase();
            } else if (2 == n2) {
                object = ((String)object).toUpperCase();
            }
        }
        return object;
    }

    private static final void saveMainTableVersionID(DataTable dataTable, MetaTable object, IDBManager iDBManager, long l2, boolean bl) throws Throwable {
        if (!object.isPersist().booleanValue()) {
            return;
        }
        Object object2 = object.getOIDColumn().getBindingDBColumnName();
        String string = bl ? "VERID" : "DVERID";
        String string2 = ((MetaColumn)object.get(string)).getBindingDBColumnName();
        object = DBUtil.getUpdateSQL((IDBManager)iDBManager, (String)object.getBindingDBTableName(), null, (String)string2, (String)object2);
        object2 = null;
        try {
            object2 = iDBManager.preparedUpdateStatement((String)object);
            string2 = new PSArgs();
            string2.addLongArg(Long.valueOf(l2));
            iDBManager.executeUpdate((PreparedStatement)object2, (String)object, (QueryArguments)string2);
        }
        finally {
            if (object2 != null) {
                object2.close();
            }
        }
        if (dataTable != null) {
            int n2 = (Integer)dataTable.getObject(0, string);
            dataTable.setInt(0, string, Integer.valueOf(n2 + 1));
        }
    }
}

