/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.doc;

import com.bokesoft.yes.mid.io.proxy.DBIOFactory;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.SaveFilterMap;

public class DocProxy {
    private Document document = null;
    private MetaDataObject metaDataObject = null;

    public DocProxy(Document document, MetaDataObject metaDataObject) {
        this.document = document;
        this.metaDataObject = metaDataObject;
    }

    public DocProxy(MetaDataObject metaDataObject) {
        this.metaDataObject = metaDataObject;
    }

    public Document loadData(DefaultContext defaultContext, FilterMap filterMap, ConditionParas conditionParas) throws Throwable {
        if (this.document == null) {
            this.document = new Document(this.metaDataObject, filterMap.getOID());
        }
        DBIOFactory.getDocIO().load(defaultContext, this.document, this.metaDataObject, filterMap, conditionParas);
        return this.document;
    }

    public Document loadData(DefaultContext defaultContext, long l2) throws Throwable {
        FilterMap filterMap = new FilterMap();
        filterMap.setOID(l2);
        return this.loadData(defaultContext, filterMap, null);
    }

    public Document loadData(DefaultContext defaultContext) throws Throwable {
        this.docNullCheck(defaultContext);
        return this.loadData(defaultContext, this.document.getOID());
    }

    public void save(DefaultContext defaultContext, SaveFilterMap saveFilterMap) throws Throwable {
        this.docNullCheck(defaultContext);
        if (this.metaDataObject.getPrimaryType() == 1) {
            return;
        }
        DBIOFactory.getDocIO().save(defaultContext, this.document, this.metaDataObject, saveFilterMap);
    }

    public void delete(DefaultContext defaultContext) throws Throwable {
        this.docNullCheck(defaultContext);
        DBIOFactory.getDocIO().delete(defaultContext, this.document, this.metaDataObject);
    }

    private void docNullCheck(DefaultContext defaultContext) {
        if (this.document == null) {
            throw new MidCoreException(4, MidCoreException.formatMessage((ILocale)defaultContext.getEnv(), (int)4, (Object[])new Object[0]));
        }
    }
}

