/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.hotdeploy;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.hotdeploy.MidMetaFactoryProcess;
import com.bokesoft.yes.mid.meta.MetaResolverFactoryBuilder;
import com.bokesoft.yes.mid.meta.MidMetaFactory;
import com.bokesoft.yes.struct.md5.RefFile;
import com.bokesoft.yes.struct.md5.RefProject;
import com.bokesoft.yes.tools.env.MetaFactoryManager;
import com.bokesoft.yes.tools.env.ResolverProfile;
import com.bokesoft.yes.tools.env.WrapMetaResolverFactory;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.app.MetaApp;
import com.bokesoft.yigo.meta.app.MetaRefFile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.mid.util.MD5Generator;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class MidMetaFactoryManager
extends MetaFactoryManager {
    private MidGlobalEnv env = null;
    boolean multiple = false;

    public MidMetaFactoryManager(MidGlobalEnv midGlobalEnv) {
        this.env = midGlobalEnv;
    }

    protected void preLoad() throws Throwable {
        this.pluginsSourcePath = SvrInfo.getWorkDir() + "plugins";
        CoreSetting.getInstance().setPluginsSourcePath(this.pluginsSourcePath);
        Object object = new File(this.pluginsSourcePath);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        } else {
            FileUtils.cleanDirectory((File)object);
        }
        object = CoreSetting.getInstance().getSolutions();
        if (object != null && object.size() > 0) {
            this.multiple = true;
        }
    }

    private IMetaFactory mergeConfig(List<ResolverProfile> object) throws Throwable {
        ArrayList<WrapMetaResolverFactory> arrayList = new ArrayList<WrapMetaResolverFactory>();
        Iterator<ResolverProfile> iterator = object.iterator();
        while (iterator.hasNext()) {
            String string;
            ResolverProfile resolverProfile = iterator.next();
            object = resolverProfile.getImpl();
            boolean bl = resolverProfile.isPrimary();
            if (StringUtil.isEmptyStr((String)object)) {
                string = TypeConvertor.toString(resolverProfile.getParas().get("SOLUTIONPATH"));
                object = new MetaResolverFactoryBuilder().build(string);
            } else {
                object = (IMetaResolverFactory)Class.forName((String)object).newInstance();
                object.initParas(resolverProfile.getParas());
            }
            if (bl) {
                string = object.getSolutionVersion();
                this.env.setVersion(string);
            }
            arrayList.add(new WrapMetaResolverFactory(resolverProfile, (IMetaResolverFactory)object));
        }
        return new MidMetaFactoryProcess(arrayList).process();
    }

    protected void load() throws Throwable {
        if (!this.multiple) {
            String string = this.solutionPath;
            string = new MetaResolverFactoryBuilder().build(string);
            this.metaFactory = new MidMetaFactory((IMetaResolverFactory)string);
            string = string.getSolutionVersion();
            this.env.setVersion(string);
            this.metaFactory.getSolution();
            this.solutionPath = this.metaFactory.getSolutionPath();
            CoreSetting.getInstance().setSolutionPath(this.metaFactory.getSolutionPath());
            return;
        }
        this.metaFactory = this.mergeConfig(CoreSetting.getInstance().getSolutions());
    }

    protected void postLoad() throws Throwable {
        super.postLoad();
        if (!(this.multiple || this.solutionPath.equals("jar") || this.solutionPath.startsWith("http://"))) {
            MidMetaFactoryManager midMetaFactoryManager = this;
            midMetaFactoryManager.generateAppDefinitionConfigMD5(midMetaFactoryManager.solutionPath);
            MD5Generator.generateServerConfigMD5(this.solutionPath, this.metaFactory);
        }
    }

    private void generateAppDefinitionConfigMD5(String string) throws Throwable {
        Object object = this.metaFactory.getAppDefinition();
        if (object == null) {
            return;
        }
        ArrayList<RefProject> arrayList = new ArrayList<RefProject>();
        object = object.iterator();
        while (object.hasNext()) {
            MetaApp metaApp = (MetaApp)object.next();
            for (Object object2 : metaApp) {
                if (object2.getKey() == null || object2.getKey().isEmpty()) continue;
                RefProject refProject = new RefProject();
                refProject.setKey(object2.getKey());
                refProject.setCaption(object2.getCaption());
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    MetaRefFile metaRefFile = (MetaRefFile)object2.next();
                    RefFile refFile = new RefFile();
                    refFile.setPath(metaRefFile.getPath());
                    refProject.addFile(refFile);
                }
                arrayList.add(refProject);
            }
            MD5Generator.generateSpecialProjectsMD5(string, metaApp.getKey(), arrayList);
            arrayList.clear();
        }
    }
}

