/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.a;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KingbaseManager
extends GeneralDBManager {
    private Set<String> keySet = new a(this);

    public KingbaseManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    public String getIndexCheckSql() {
        return "SELECT indexname FROM pg_indexes WHERE UPPER(indexname) = ? AND schemaname = ?";
    }

    public String getIndexSearchSql() {
        return "SELECT tablename FROM pg_indexes WHERE UPPER(indexname) = ? AND schemaname = ?";
    }

    public String getViewExistCheckSql() {
        return "select count(TABLE_NAME) count from information_schema.`VIEWS` WHERE UPPER(TABLE_NAME) = ?  and TABLE_SCHEMA = ?";
    }

    public String getTableExistCheckSql() {
        return "select count(TABLE_NAME) count from information_schema.`TABLES` WHERE UPPER(TABLE_NAME) = ?  and TABLE_SCHEMA = ?";
    }

    @Override
    public boolean checkViewExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getViewExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string);
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public boolean checkTableExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getTableExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string);
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public HashSet<String> getTableColumnSet(String string) throws Throwable {
        String string2 = this.getColumnCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    @Override
    public HashSet<String> getIndexSet(String string) throws Throwable {
        String string2 = this.getIndexCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    @Override
    public String searchIndex(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getIndexSearchSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getSchema());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                string = resultSet.getString(1);
                return string;
            }
            return null;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public String getColumnCheckSql() {
        return "select COLUMN_NAME from information_schema.COLUMNS where UPPER(TABLE_NAME)=?   and TABLE_SCHEMA = ?";
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add ";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + ", add " + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return object;
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                if (!metaSchemaColumn.isCaseSensitive()) break;
                string = string + "COLLATE utf8_bin";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " timestamp ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " double ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " int";
                break;
            }
            case 1011: {
                string = " text ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1010: {
                string = " bigint";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728KingbaseManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        String string2 = string.toLowerCase();
        if (this.keySet.contains(string2)) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        String string2 = string.toLowerCase();
        if (this.keySet.contains(string2)) {
            return stringBuilder.append("\"").append(string).append("\"");
        }
        return stringBuilder.append(string);
    }

    public int getDBType() {
        return 13;
    }

    @Override
    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (n3 == 101 && (n2 == 1006 || n2 == 1007 || n2 == 1005)) {
            return new BigDecimal((Double)object);
        }
        if (n3 == 100 && (n2 == 1007 || n2 == 1006 || n2 == 1005)) {
            return new BigDecimal(((Float)object).floatValue());
        }
        return super.convert(object, n2, n3);
    }

    @Override
    public int convertDataType(int n2) {
        if (n2 == 101) {
            return 1006;
        }
        if (n2 == 100) {
            return 1007;
        }
        return super.convertDataType(n2);
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.insert(stringBuilder2.length(), "'").insert(6, "-").insert(4, "-").insert(0, "'");
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                stringBuilder3.insert(stringBuilder3.length(), "'").insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-").insert(0, "'");
            }
            return stringBuilder.toString();
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder4 = stringBuilder;
        stringBuilder4.insert(stringBuilder4.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
            }
            string2 = stringBuilder.toString();
            return string + " like '%" + string2 + "%'";
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        boolean bl2 = string2 != null && string2.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" order by ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(bl ? " limit ?, ?" : " limit ?");
        string = new PrepareSQL();
        string.setSQL(stringBuilder.toString());
        if (bl) {
            string.addValue((Object)n2);
            string.addValue((Object)(n3 - n2));
        } else {
            string.addValue((Object)n3);
        }
        return string;
    }

    public String getTableStructSql() {
        return "select TABLE_NAME from information_schema.`TABLES` WHERE TABLE_SCHEMA = ?";
    }

    public String getColumnStructSql() {
        return "select COLUMN_NAME,TABLE_NAME from information_schema.COLUMNS where TABLE_SCHEMA = ?";
    }

    public String getIndexStructSql() {
        return "SELECT i.relname AS INDEX_NAME, t.relname AS TABLE_NAME, a.attname AS COLUMN_NAME, CASE ix.indisunique WHEN true THEN 0 ELSE 1 END AS NON_UNIQUE, pos AS SEQ_IN_INDEX FROM pg_class t, pg_class i, pg_index ix, pg_attribute a, pg_namespace n\uff0cunnest(ix.indkey) WITH ORDINALITY AS k(attnum, pos) WHERE t.oid = ix.indrelid AND i.oid = ix.indexrelid AND a.attrelid = t.oid AND a.attnum = ANY(ix.indkey) AND t.relnamespace = n.oid AND a.attnum = k.attnum AND n.nspname = ?";
    }

    public String getViewStructSql() {
        return "select TABLE_NAME from information_schema.`VIEWS` WHERE TABLE_SCHEMA = ?";
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        PreparedStatement preparedStatement;
        block5: {
            String string = this.getTableStructSql();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getSchema());
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initTable(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getViewStructSql();
                preparedStatement = this.prepareStatement(string);
                pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getSchema());
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initView(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getColumnStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initColumn(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getIndexStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initIndex(resultSet);
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }
}

