/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.rights.setright;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.rights.IRightsProxy;
import com.bokesoft.yes.mid.rights.MidRightsProxyFactory;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.rights.cache.BindingServiceIDsCache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.rights.MetaFormRightsCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.rights.FormRights;
import com.bokesoft.yigo.struct.rights.ServiceRights;
import java.util.Map;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveFormRightsCmd
extends DefaultServiceCmd {
    private static final Logger logger = LoggerFactory.getLogger(SaveFormRightsCmd.class);
    private String formKey = "";
    private long operatorID = 0L;
    private long roleID = 0L;
    private JSONArray opt;
    private JSONArray visible;
    private JSONArray enable;
    private boolean allOptRights = false;
    private boolean allVisibleRights = false;
    private boolean allEnableRights = false;

    public IServiceCmd<DefaultContext> newInstance() {
        return new SaveFormRightsCmd();
    }

    public void dealArguments(DefaultContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"formKey"));
        this.operatorID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"operatorID"));
        this.roleID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"roleID"));
        this.allOptRights = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"allOptRights"));
        if (!this.allOptRights) {
            object = TypeConvertor.toString((Object)stringHashMap.get((Object)"optRights"));
            this.opt = ((String)object).isEmpty() ? new JSONArray() : new JSONArray((String)object);
        }
        this.allEnableRights = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"allEnableRights"));
        if (!this.allEnableRights) {
            object = TypeConvertor.toString((Object)stringHashMap.get((Object)"enableRights"));
            this.enable = ((String)object).isEmpty() ? new JSONArray() : new JSONArray((String)object);
        }
        this.allVisibleRights = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"allVisibleRights"));
        if (!this.allVisibleRights) {
            object = TypeConvertor.toString((Object)stringHashMap.get((Object)"visibleRights"));
            this.visible = ((String)object).isEmpty() ? new JSONArray() : new JSONArray((String)object);
        }
    }

    private IRightsProxy getRightsProxy(DefaultContext defaultContext, long l2, long l3) {
        defaultContext = l2 > 0L ? MidRightsProxyFactory.getInstance().createOperatorRightsProxy(defaultContext) : MidRightsProxyFactory.getInstance().createRoleRightsProxy(defaultContext);
        return defaultContext;
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        ServiceRights serviceRights;
        if (this.formKey.isEmpty()) {
            throw new RuntimeException("\u4fdd\u5b58\u6743\u9650\u64cd\u4f5c\uff0cformKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MetaFormRightsCollection metaFormRightsCollection = defaultContext.getVE().getMetaFactory().getRightsDefinition().getFormRightsCollection();
        if (!(metaFormRightsCollection == null || metaFormRightsCollection.size() != 0 && metaFormRightsCollection.contains(this.formKey))) {
            return Boolean.TRUE;
        }
        metaFormRightsCollection = this.getRightsProxy(defaultContext, this.operatorID, this.roleID);
        long l2 = this.operatorID > 0L ? this.operatorID : this.roleID;
        FormRights formRights = RightsProviderFactory.getInstance().newRightsProvider(defaultContext).getFormRights(this.formKey);
        ServiceRights serviceRights2 = null;
        if (formRights.hasAllOptRights()) {
            SaveFormRightsCmd saveFormRightsCmd = this;
            serviceRights2 = saveFormRightsCmd.setFormServiceRights(saveFormRightsCmd.formKey);
        } else if (!formRights.getOptRights().isEmpty()) {
            for (String string : formRights.getOptRights()) {
                SaveFormRightsCmd saveFormRightsCmd = this;
                serviceRights2 = saveFormRightsCmd.setServiceRightsByFormOpt(saveFormRightsCmd.formKey, string);
            }
        }
        if (serviceRights2 == null || serviceRights2.getServiceIDs() == null) {
            throw new RuntimeException("\u8868\u5355\u65e0\u670d\u52a1\u6743\u9650");
        }
        logger.debug("SaveFormRightsCmd.doCmd().oldServices:" + serviceRights2.getServiceIDs().toString());
        if (this.allOptRights && this.allVisibleRights && this.allEnableRights) {
            defaultContext = formRights;
            SaveFormRightsCmd saveFormRightsCmd = this;
            serviceRights = saveFormRightsCmd.setFormServiceRights(saveFormRightsCmd.formKey);
        } else {
            String string;
            defaultContext = new FormRights(this.formKey);
            serviceRights = new ServiceRights();
            if (this.allOptRights) {
                defaultContext.setAllOptRights(formRights.hasAllOptRights());
                defaultContext.getOptRights().addAll(formRights.getOptRights());
            } else {
                for (int i2 = 0; i2 < this.opt.length(); ++i2) {
                    string = this.opt.getString(i2);
                    if (!formRights.hasOptRights(string)) continue;
                    defaultContext.addOptRights(string);
                    new ServiceRights();
                    SaveFormRightsCmd saveFormRightsCmd = this;
                    string = saveFormRightsCmd.setServiceRightsByFormOpt(saveFormRightsCmd.formKey, string);
                    serviceRights.getServiceIDs().addAll(string.getServiceIDs());
                }
            }
            if (this.allVisibleRights) {
                if (formRights.hasAllVisibleRights()) {
                    defaultContext.setAllVisibleRights(true);
                } else {
                    defaultContext.addVisibleRights(formRights.getVisibleRights());
                }
            } else {
                defaultContext.addVisibleRights(formRights.getVisibleRights());
                for (int i3 = 0; i3 < this.visible.length(); ++i3) {
                    string = this.visible.getString(i3);
                    if (!formRights.hasVisibleRights(string)) continue;
                    defaultContext.addVisibleRights(string);
                }
            }
            if (this.allEnableRights) {
                if (formRights.hasAllEnableRights()) {
                    defaultContext.setAllEnableRights(true);
                } else {
                    defaultContext.addEnableRights(formRights.getEnableRights());
                }
            } else {
                defaultContext.addEnableRights(formRights.getEnableRights());
                for (int i4 = 0; i4 < this.enable.length(); ++i4) {
                    string = this.enable.getString(i4);
                    if (!formRights.hasEnableRights(string)) continue;
                    defaultContext.addEnableRights(string);
                }
            }
        }
        metaFormRightsCollection.saveFormRights(l2, (FormRights)defaultContext);
        logger.debug("SaveFormRightsCmd.doCmd().newServices:" + serviceRights.getServiceIDs().toString());
        metaFormRightsCollection.saveServiceRights(l2, serviceRights, serviceRights2);
        return Boolean.TRUE;
    }

    private ServiceRights setFormServiceRights(String string) throws Throwable {
        ServiceRights serviceRights = new ServiceRights();
        for (Map.Entry entry : BindingServiceIDsCache.formoptBindingServices.entrySet()) {
            ServiceRights serviceRights2;
            if (!((String)entry.getKey()).startsWith(string + ",") || (serviceRights2 = (ServiceRights)entry.getValue()) == null || serviceRights2.getServiceIDs().isEmpty()) continue;
            serviceRights.getServiceIDs().addAll(serviceRights2.getServiceIDs());
        }
        return serviceRights;
    }

    private ServiceRights setServiceRightsByFormOpt(String string, String string2) throws Throwable {
        ServiceRights serviceRights = new ServiceRights();
        if ((string = (ServiceRights)BindingServiceIDsCache.formoptBindingServices.get(string + "," + string2)) != null && !string.getServiceIDs().isEmpty()) {
            serviceRights.getServiceIDs().addAll(string.getServiceIDs());
        }
        return serviceRights;
    }

    public String getCmd() {
        return "SaveFormRights";
    }

    public void setFormKey(String string) {
        this.formKey = string;
    }

    public void setOperatorID(long l2) {
        this.operatorID = l2;
    }

    public void setRoleID(long l2) {
        this.roleID = l2;
    }

    public void setOpt(JSONArray jSONArray) {
        this.opt = jSONArray;
    }

    public void setVisible(JSONArray jSONArray) {
        this.visible = jSONArray;
    }

    public void setEnable(JSONArray jSONArray) {
        this.enable = jSONArray;
    }

    public void setAllOptRights(boolean bl) {
        this.allOptRights = bl;
    }

    public void setAllVisibleRights(boolean bl) {
        this.allVisibleRights = bl;
    }

    public void setAllEnableRights(boolean bl) {
        this.allEnableRights = bl;
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

