/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.gantt;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class SaveGanttDataCmd
extends DefaultServiceCmd {
    private String dataObjectKey = "";
    private Document document = null;
    private MetaDataObject metaDataObject = null;
    private int verid = 0;

    public SaveGanttDataCmd(String string, Document document) {
        this.dataObjectKey = string;
        this.document = document;
    }

    public SaveGanttDataCmd() {
    }

    public String getCmd() {
        return "SaveGanttData";
    }

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> object) throws Throwable {
        long l2;
        Object object2 = object.get((Object)"ganttdata");
        object2 = new JSONObject(TypeConvertor.toString((Object)object2));
        this.dataObjectKey = TypeConvertor.toString((Object)object.get((Object)"dataObjectKey"));
        object = defaultContext.getVE().getMetaFactory();
        this.metaDataObject = object.getDataObject(this.dataObjectKey);
        this.document = SaveGanttDataCmd.createEmptyDocument(this.metaDataObject);
        this.document.setNew();
        object = this.metaDataObject.getMainTableKey();
        long l3 = l2 = object2.has("oid") ? object2.getLong("oid") : -1L;
        if (object2.has("verid")) {
            this.verid = TypeConvertor.toInteger((Object)object2.get("verid"));
            this.checkVerID(defaultContext, (String)object, l2, this.verid);
        }
        object = this.document.get((String)object);
        this.initMainTable((DataTable)object, (JSONObject)object2, l2);
        this.document.setOID(l2);
        object = this.metaDataObject.getMainTable().getKey();
        this.clearOldData(defaultContext, (String)object, l2);
        SaveGanttDataCmd saveGanttDataCmd = this;
        object = saveGanttDataCmd.getGanttTableKey(saveGanttDataCmd.metaDataObject);
        this.clearOldData(defaultContext, (String)object, l2);
        String string = ((MetaTable)this.metaDataObject.getTableCollection().get(2)).getKey();
        this.clearOldData(defaultContext, string, l2);
        defaultContext = this.document.get((String)object);
        this.fillDetail((DataTable)defaultContext, (JSONObject)object2);
        defaultContext = this.document.get(2);
        this.fillResources((DataTable)defaultContext, (JSONObject)object2);
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        Document document = new SaveData(this.dataObjectKey, null, this.document).save(defaultContext);
        this.updateVerID(defaultContext, this.metaDataObject, document.getOID(), this.verid);
        return document.getOID();
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new SaveGanttDataCmd();
    }

    private void checkVerID(DefaultContext defaultContext, String string, long l2, int n2) throws Throwable {
        string = String.format("select verid from %s where oid=?", string);
        string = defaultContext.getDBManager().execPrepareQuery(string, new Object[]{l2});
        if (string.size() == 0) {
            return;
        }
        if (string.getInt("verid") > n2) {
            throw new MidCoreException(15, MidCoreException.formatMessage((ILocale)defaultContext.getEnv(), (int)15, (Object[])new Object[]{this.document.getState()}));
        }
    }

    private void updateVerID(DefaultContext defaultContext, MetaDataObject object, long l2, int n2) throws Throwable {
        Iterator iterator = object.getTableCollection().iterator();
        String string = object.getMainTableKey();
        while (iterator.hasNext()) {
            String string2 = ((MetaTable)iterator.next()).getKey();
            object = string.equalsIgnoreCase(string2) ? "update %s set verid=? where oid=?" : "update %s set verid=? where soid=?";
            object = String.format((String)object, string2);
            defaultContext.getDBManager().execPrepareUpdate((String)object, new Object[]{n2 + 1, l2});
        }
    }

    private long initMainTable(DataTable dataTable, JSONObject jSONObject, long l2) {
        if (dataTable.size() == 0) {
            dataTable.append();
            dataTable.setDateTime("BillDate", (Date)DateUtil.getNowTime());
            dataTable.setLong("oid", Long.valueOf(l2));
            dataTable.setLong("soid", Long.valueOf(l2));
            if (jSONObject.has("ganttname")) {
                dataTable.setObject("GanttName", jSONObject.get("ganttname"));
            }
        }
        return l2;
    }

    private void fillDetail(DataTable dataTable, JSONObject jSONObject) {
        int n2 = dataTable.getMetaData().getColumnCount();
        jSONObject = (JSONArray)jSONObject.get("tasks");
        for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
            JSONObject jSONObject2 = (JSONObject)jSONObject.get(i2);
            dataTable.append();
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = dataTable.getMetaData().getColumnInfo(i3);
                String string = object.getColumnKey();
                if (!jSONObject2.has(string) || "id".equalsIgnoreCase(string)) continue;
                object = TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)object.getDataType()), (Object)jSONObject2.get(string));
                dataTable.setObject(string, object);
            }
        }
    }

    private void fillResources(DataTable dataTable, JSONObject jSONObject) {
        jSONObject = (JSONArray)jSONObject.get("resources");
        int n2 = dataTable.getMetaData().getColumnCount();
        for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
            JSONObject jSONObject2 = (JSONObject)jSONObject.get(i2);
            dataTable.append();
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = dataTable.getMetaData().getColumnInfo(i3);
                String string = object.getColumnKey();
                if (!jSONObject2.has(string)) continue;
                object = TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)object.getDataType()), (Object)jSONObject2.get(string));
                dataTable.setObject(string, object);
            }
        }
    }

    private static final Document createEmptyDocument(MetaDataObject object) throws Throwable {
        Document document = new Document((MetaDataObject)object, -1L);
        for (MetaTable metaTable : object.getTableCollection()) {
            DataTable dataTable = DataTableUtil.newEmptyDataTable((MetaTable)metaTable);
            document.add(metaTable.getKey(), dataTable);
        }
        return document;
    }

    private void clearOldData(DefaultContext defaultContext, String string, long l2) throws Throwable {
        string = String.format("delete from %s where soid=?", string);
        defaultContext.getDBManager().execPrepareUpdate(string, new Object[]{l2});
    }

    private String getGanttTableKey(MetaDataObject object) {
        for (MetaTable metaTable : object.getTableCollection()) {
            if (!metaTable.containsKey("duration") || !metaTable.containsKey("start") || !metaTable.containsKey("startIsMilestone")) continue;
            return metaTable.getKey();
        }
        return "";
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

