/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.gantt;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadDataDirect;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadGanttDataCmd
extends DefaultServiceCmd {
    private String dataObjectKey = "";
    private long oid = 0L;

    public String getCmd() {
        return "LoadGanttData";
    }

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.dataObjectKey = (String)stringHashMap.get((Object)"dataObjectKey");
        this.oid = TypeConvertor.toLong((Object)stringHashMap.get((Object)"oid"));
    }

    public Object doCmd(DefaultContext object) throws Throwable {
        object = new LoadDataDirect(this.dataObjectKey, this.oid).load((DefaultContext)object);
        DataTable dataTable = object.get(1);
        JSONObject jSONObject = new JSONObject();
        dataTable = this.getGanttDetail(dataTable);
        jSONObject.put("tasks", (Object)dataTable);
        dataTable = object.get(2);
        dataTable = this.getGanttResouce(dataTable);
        jSONObject.put("resources", (Object)dataTable);
        jSONObject.put("selectedRow", 0);
        jSONObject.put("canWrite", true);
        jSONObject.put("canWriteOnParent", true);
        jSONObject.put("oid", this.oid);
        jSONObject.put("verid", object.getVERID());
        if (object.get(0).size() > 0) {
            object = object.get(0).getString("GanttName");
            jSONObject.put("ganttname", object);
        }
        return jSONObject;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadGanttDataCmd();
    }

    private JSONArray getGanttDetail(DataTable dataTable) {
        JSONArray jSONArray = new JSONArray();
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int n2 = dataTableMetaData.getColumnCount();
        dataTable.beforeFirst();
        while (dataTable.next()) {
            JSONObject jSONObject = new JSONObject();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i2);
                String string = columnInfo.getColumnKey();
                if ("assigs".equalsIgnoreCase(string)) {
                    object = TypeConvertor.toString((Object)dataTable.getObject(i2));
                    if (StringUtil.isBlankOrNull((String)object)) {
                        object = "[]";
                    }
                    jSONObject.put(columnInfo.getColumnKey(), (Object)new JSONArray((String)object));
                    continue;
                }
                if ("id".equalsIgnoreCase(string)) continue;
                if (1004 == columnInfo.getDataType() || 1003 == columnInfo.getDataType()) {
                    object = dataTable.getDateTime(i2);
                    jSONObject.put(string, ((Date)object).getTime());
                    continue;
                }
                if ("oid".equalsIgnoreCase(string)) {
                    jSONObject.put("id", dataTable.getObject(i2));
                }
                jSONObject.put(columnInfo.getColumnKey(), dataTable.getObject(i2));
            }
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    private JSONArray getGanttResouce(DataTable dataTable) {
        JSONArray jSONArray = new JSONArray();
        dataTable.beforeFirst();
        while (dataTable.next()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("oid", dataTable.getObject("oid"));
            jSONObject.put("id", dataTable.getObject("id"));
            jSONObject.put("name", dataTable.getObject("Name"));
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

