package com.bokesoft.yigo.mid.util.resource.icon.css.generator;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

import com.bokesoft.yes.common.util.Base64Utils;

public class GenerateUtil {

    public static String getBase64StrByInputStream(InputStream inputStream, String path) throws Exception {
        if (inputStream == null) {
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(); BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream)) {
            Object object = new byte[65536];
            int i;
            while (-1 != (i = bufferedInputStream.read((byte[]) object, 0, 65536)))
                byteArrayOutputStream.write((byte[]) object, 0, i);
            return "data:" +  Files.probeContentType(Paths.get(path)) +  ";base64," + Base64Utils.encode(byteArrayOutputStream.toByteArray());
        } finally {
            inputStream.close();
        }
    }
}
