package com.bokesoft.yigo.mid.util.resource.icon;

public class SourceIdentifier {

    public static final int TYPE_RESOURCE = 0;
    public static final String STR_TYPE_RESOURCE_PREFIX = "resource";
    public static final int TYPE_ICONFONT = 1;
    public static final String STR_TYPE_ICONFONT_PREFIX = "font";
    public static final int TYPE_BASE64 = 2;
    public static final String STR_TYPE_BASE64_PREFIX = "base64";
    public static final int TYPE_EMPTY = 3;
    public static final String STR_TYPE_EMPTY = "-";
    private final String content;

    private final int type;

    public SourceIdentifier(String content, int type) {
        this.content = content;
        this.type = type;
    }

    public String getContent() {
        return content;
    }

    public int getType() {
        return type;
    }

    public static SourceIdentifier parse(String source) throws Throwable {
        int type;
        if (source.equals(STR_TYPE_EMPTY)) {
            return new SourceIdentifier("", TYPE_EMPTY);
        } else {
            int index = source.indexOf(":");
            if (index > 0) {
                String typeStr = source.substring(0, index);
                String content = source.substring(index + 1);
                if (typeStr.equalsIgnoreCase(STR_TYPE_RESOURCE_PREFIX)) {
                    type = TYPE_RESOURCE;
                } else if (typeStr.equalsIgnoreCase(STR_TYPE_ICONFONT_PREFIX)) {
                    type = TYPE_ICONFONT;
                } else if (typeStr.equalsIgnoreCase(STR_TYPE_BASE64_PREFIX)) {
                    type = TYPE_BASE64;
                } else {
                    type = TYPE_RESOURCE;
                }

                return new SourceIdentifier(content, type);
            } else {
                return null;
            }
        }

    }
}
