package com.bokesoft.yigo.mid.util.resource.icon;

import java.util.Date;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.util.resource.icon.css.CssSourceGeneratorFactory;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.ICSSSourceGenerator;
import com.bokesoft.yigo.mid.util.resource.icon.provider.IIconSourceProvider;
import com.bokesoft.yigo.mid.util.resource.icon.provider.IconSourceProviderRegistry;

/**
 * IconSourceUtil
 */
public class IconSourceUtil {
//	private static final String CSS_FILE_PATH = "Resource" + File.separator + "icon-source-temp.css";
//	private static final String CSS_CLASS_INFO_PATH = "Resource" + File.separator + "icon-source-info-temp";

	private static String cssData;

	private static String cssClassInfo;

	/**
	 * 生成css文件
	 *
	 * @param factory
	 * @return 文件路径
	 */
	public static void generateCssSource(IMetaFactory factory) throws Throwable {

		LogSvr.getInstance().info("开始生成IconSource css文件");
		Date start = new Date();
		IconSourceUtil.clearFile(factory);

		MetaIconSourceCollection collection = new MetaIconSourceCollection();
		// 配置获取
		MetaIconSourceCollection metaCollection = factory.getIconSourceCollection();
		collection.merge(metaCollection);

		// 接口获取
		MetaIconSourceCollection providerCollection = IconSourceUtil.getIconSourceCollectionByProvider(factory);
		collection.merge(providerCollection);

		// 生成css
		generateCss(collection, factory);

		Date end = new Date();
		long difference = end.getTime() - start.getTime();
		LogSvr.getInstance().info("结束生成IconSource css文件。生成数：" + collection.size() + ",耗时：" + difference);
	}

	private static void generateCss(MetaIconSourceCollection iconSourceCollection, IMetaFactory factory)
			throws Throwable {

		StringBuilder str = new StringBuilder();
		// iconSource
		if (iconSourceCollection == null) {
			return;
		}

		// iconsource和生成的class的映射
		JSONArray iconSourceInfos = new JSONArray();

		// 生成css字符
		for (int i = 0; i < iconSourceCollection.size(); i++) {
			MetaIconSource iconSource = iconSourceCollection.get(i);
			String key = iconSource.getKey();
			String scene = iconSource.getScene();
			String nodeString = "";
			JSONObject iconSourceInfo = new JSONObject();
			try {
				ICSSSourceGenerator generator = CssSourceGeneratorFactory.getGenerator(scene);
				if (generator != null) {
					nodeString = generator.generateIcon(factory, iconSource);
					iconSourceInfo.put("key", iconSource.getKey());
					iconSourceInfo.put("scene", iconSource.getScene());
					iconSourceInfo.put("className", generator.getIconClassName(factory, iconSource));
					Integer displayMode = iconSource.getDisplayMode();
					if (displayMode != null) {
						iconSourceInfo.put("displayMode", iconSource.getDisplayMode());
					}
				}
			} catch (Exception e) {
				nodeString = null;
				LogSvr.getInstance().error("generate failed, IconSource:" + key + " scene:" + scene, e);
			}

			if (nodeString != null && !nodeString.isEmpty()) {
				str.append("\r\n");
				str.append(nodeString);
				iconSourceInfos.put(iconSourceInfo);
			}
		}
		if (str.length() > 0) {
			str.append("[class*=" + ICSSSourceGenerator.PREFIX_CLASS + "]");
			str.append("{");
			str.append("background-repeat: no-repeat;");
			str.append("background-size: cover;"); 
			str.append("background-position: center center;");
			str.append("}");

			str.append("[class*=" + ICSSSourceGenerator.PREFIX_CLASS + "]::before");
			str.append("{");
			str.append("align-items: center;");
			str.append("justify-content: center;");
			str.append("display: flex;");
			str.append("height: 100%;");
			str.append("width: 100%;");
			str.append("}");
			cssData = str.toString();
			cssClassInfo = iconSourceInfos.toString();
			LogSvr.getInstance().info("IconSource资源占用内存大小：" + cssData.getBytes().length + cssClassInfo.getBytes().length + "byte");
		}
	}

	private static void clearFile(IMetaFactory factory) throws Throwable {
		cssData = null;
		cssClassInfo = null;
	}

	public static String getIconSourceCss(IMetaFactory factory) throws Throwable {
		return cssData;
	}

	public static String getIconSourceClassMap(IMetaFactory factory) throws Throwable {
		return cssClassInfo;
	}

	private static MetaIconSourceCollection getIconSourceCollectionByProvider(IMetaFactory factory) throws Throwable {
		Map<String, IIconSourceProvider> providers = IconSourceProviderRegistry.getProviders();
		MetaIconSourceCollection resultCollection = new MetaIconSourceCollection();
		for (String keyString : providers.keySet()) {
			IIconSourceProvider provider = providers.get(keyString);
			MetaIconSourceCollection collection = provider.getIconSourceCollection(factory);
			if (collection != null) {
				resultCollection.merge(collection);
			}
		}
		return resultCollection;
	}
}