package com.bokesoft.yigo.mid.util;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.TableFilterDetail;

public class DocumentUtil {
	
	/**
	 * 载入document
	 * @param formKey
	 * @param OID
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public static Document loadDocument(String formKey, long OID, DefaultContext context) throws Throwable {
		LoadFormData load = new LoadFormData(formKey, OID);
		Document document = load.load(context, null);
		return document;
	}
	

	/**
	 * 判断界面是否存在数据分页的情况
	 * @param formKey
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public static boolean isPaginationForm(String formKey, DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataObject metaDataObject = MetaUtil.getDataObject(metaFactory, metaForm);
		Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
		return isPaginationForm(metaForm, itTables);
	}
	
	public static boolean isPaginationForm(MetaForm metaForm, Iterator<MetaTable> itTables) throws Throwable {
		MetaTable metaTable = null;
		while (itTables.hasNext()) {
			metaTable = itTables.next();
			int tableModel = metaTable.getTableMode();
			switch (tableModel) {
			case TableMode.DETAIL:
				MetaComponent metaComponent = metaForm.findComponentByTable(metaTable.getKey());
				if( metaComponent == null )
					break;
				switch (metaComponent.getControlType()) {
				case ControlType.GRID:
					MetaGrid metaGrid = (MetaGrid)metaComponent;
					if( metaGrid.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				case ControlType.LISTVIEW:
					MetaListView metaListView = (MetaListView)metaComponent;
					if( metaListView.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				case ControlType.EDITVIEW:
					MetaEditView metaEditView = (MetaEditView)metaComponent;
					if( metaEditView.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				}
			}
		}
		return false;
	}

	/**
	 * 处理总行数加载
	 * @param metaForm
	 * @param fm
	 */
	public static void processFilterMap(MetaForm metaForm, FilterMap fm) {
		MetaDataSource metaDataSource = metaForm.getDataSource();
		if(metaDataSource == null) {
			return;
		}
		MetaDataObject metaDataObject = metaDataSource.getDataObject();
		if(metaDataObject == null) {
			return;
		}

		MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
		if(metaTableCollection == null) {
			return;
		}
		Iterator<MetaTable> itTables = metaTableCollection.iterator();
		MetaTable metaTable = null;
		while (itTables.hasNext()) {
			metaTable = itTables.next();
			int tableMode = metaTable.getTableMode();
			String tableKey = metaTable.getKey();
			if(tableMode == TableMode.DETAIL) {
				MetaComponent metaComponent = metaForm.findComponentByTable(tableKey);
				if(metaComponent == null) continue;
				Boolean showTotalRowCount = null;
				switch (metaComponent.getControlType()) {
					case ControlType.GRID:
						MetaGrid metaGrid = (MetaGrid) metaComponent;
						showTotalRowCount = metaGrid.isShowTotalRowCount();
						break;
					case ControlType.LISTVIEW:
						MetaListView metaListView = (MetaListView) metaComponent;
						showTotalRowCount = metaListView.isShowTotalRowCount();
						break;
					case ControlType.EDITVIEW:
					case ControlType.TILEDLIST:
					case ControlType.GALLERY:
					case ControlType.ROTATOR:
					case ControlType.ROTATORLIST:
					case ControlType.WATERFALL:
						MetaEditView metaEditView = (MetaEditView) metaComponent;
						showTotalRowCount = metaEditView.isShowTotalRowCount();
						break;

				}

				TableFilterDetail tfd = fm.getTableFilter(tableKey);
				if(tfd != null) {
					tfd.setQueryTotalRowCount(showTotalRowCount);
				}
			}
		}
	}
}
