package com.bokesoft.yigo.mid.util;

import java.util.ArrayList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;

/**
 * 单张表生成SQL语句 仅为ERP提供， 其他项目二开建议调用SaveData
 */
public class DocumentDBUtil {
	
	/**
	 * 根据DataTable生成SQL语句
	 * @param DBManager 数据库对象
	 * @param table 要生成SQL语句的DataTable
	 * @param metaTable DataTable对应的配置对象
	 * @param insertBatch 批量插入对象
	 * @param updateBatch 批量更新对象
	 * @param deleteBatch 批量删除对象
	 * @throws Throwable
	 */
	public static void createSQL(IDBManager DBManager, DataTable table, MetaTable metaTable, BatchPsPara insertBatch, BatchPsPara updateBatch, BatchPsPara deleteBatch) throws Throwable {

		if (table == null)
			return;

		if (!metaTable.isPersist())
			return;

		// 将删除状态的数据显示出来
		table.setShowDeleted(true);

		// 构造更新使用的SQL语句
		int fieldSize = table.getMetaData().getColumnCount();
		String OIDDBKey = metaTable.getOIDColumn().getBindingDBColumnName();

		ArrayList<String> updateFieldList = new ArrayList<String>(fieldSize);// 需要更新的字段
		ArrayList<String> insertFieldList = new ArrayList<String>(fieldSize);// 需要插入的字段
		ArrayList<Integer> updateKeyIndex = new ArrayList<Integer>(fieldSize);// 每个更新字段在数据表中列的索引
		ArrayList<Integer> insertKeyIndex = new ArrayList<Integer>(fieldSize);// 每个插入字段在数据表中列的索引

		DataTableMetaData tableMetaData = table.getMetaData();
		int[] columnFieldTypes = new int[fieldSize];
		for (MetaColumn metaColumn : metaTable) {
			String key = metaColumn.getKey();
			int columnIndex = tableMetaData.findColumnIndexByKey(key);
			ColumnInfo columnInfo = columnIndex >= 0 ? tableMetaData.getColumnInfo(columnIndex) : null;
			if (columnInfo == null) 
				continue;
			if (!metaColumn.isPersist())
				continue;
			if (metaColumn.isIgnoreSave())
				continue;
			if(!columnInfo.isHasWriteRights())
				continue;//在权限过滤阶段，如果被标识不可写，则忽略该列
			columnFieldTypes[columnIndex] = columnInfo.getDataType();
			String dbKey = metaTable.get(key).getBindingDBColumnName();
			insertFieldList.add(dbKey);
			insertKeyIndex.add(columnIndex);
			if (!metaColumn.isSystemControlField()) {
				updateFieldList.add(dbKey);
				updateKeyIndex.add(columnIndex);
			}
		}
		
		
//		for (int i = 0; i < fieldSize; i++) {
//			ColumnInfo columnInfo = tableMetaData.getColumnInfo(i);
//			columnFieldTypes[i] = columnInfo.getDataType();
//			String key = columnInfo.getColumnKey();
//			MetaColumn metaColumn = metaTable.get(key);
//			if (metaColumn == null)
//				continue;
//			if (!metaColumn.isPersist())
//				continue;
//			if (metaColumn.isIgnoreSave())
//				continue;
//			if(!columnInfo.isHasWriteRights())
//				continue;//在权限过滤阶段，如果被标识不可写，则忽略该列
//			String dbKey = metaTable.get(key).getBindingDBColumnName();
//			insertFieldList.add(dbKey);
//			insertKeyIndex.add(i);
//			if (!metaColumn.isSystemControlField()) {
//				updateFieldList.add(dbKey);
//				updateKeyIndex.add(i);
//			}
//		}
		
		String deleteSQL = null;
		String updateSQL = null;
		String insertSQL = null;
		
		PSArgs args = null;			

		table.beforeFirst();
		while (table.next()) {
			int rowState = table.getState();
			if (rowState == RowState.DELETED) { // 删除

				if (deleteSQL == null){
					deleteSQL = DBUtil.getDeleteSQL(DBManager, metaTable.getBindingDBTableName(), OIDDBKey);
					deleteBatch.setSql(deleteSQL);
				}
				
				args = new PSArgs();
				args.addArg(DataType.LONG, table.getObject(SystemField.OID_SYS_KEY));
				deleteBatch.putArgs(args);

			} else if (rowState == RowState.MODIFIED) {// 更新

				if (updateSQL == null) {
					updateSQL = DBUtil.getUpdateSQL(DBManager, metaTable.getBindingDBTableName(), updateFieldList, OIDDBKey);
					updateBatch.setSql(updateSQL);
				}
				
				args = new PSArgs();
				
				Object[] rv = table.impl_getRow();
				for (int index : updateKeyIndex) {
					Object value = rv[index];
					if (StringUtil.isBlankOrNull(value)) {
						if (columnFieldTypes[index] == DataType.STRING || columnFieldTypes[index] == DataType.FIXED_STRING || columnFieldTypes[index] == DataType.TEXT) {
							value = StringUtil.OneBlank_STRING;
						} else if (columnFieldTypes[index] == DataType.INT || columnFieldTypes[index] == DataType.NUMERIC || columnFieldTypes[index] == DataType.DOUBLE
								|| columnFieldTypes[index] == DataType.FLOAT || columnFieldTypes[index] == DataType.LONG) {
							value = TypeConvertor.toDataType(columnFieldTypes[index], 0);
						}
					}
					args.addArg(columnFieldTypes[index], value);
				}
				
				args.addArg(DataType.LONG, table.getObject(SystemField.OID_SYS_KEY));
				updateBatch.putArgs(args);

			} else if (rowState == RowState.NEW) {// 插入
			
				if (insertSQL == null){
					insertSQL = DBUtil.getInsertSQL(DBManager, metaTable.getBindingDBTableName(), insertFieldList);
					insertBatch.setSql(insertSQL);
				}

				args = new PSArgs();
				
				Object[] rv = table.impl_getRow();
				for (int index : insertKeyIndex) {
					Object value = rv[index];
					if (StringUtil.isBlankOrNull(value)) {
						if (columnFieldTypes[index] == DataType.STRING || columnFieldTypes[index] == DataType.FIXED_STRING || columnFieldTypes[index] == DataType.TEXT) {
							value = StringUtil.OneBlank_STRING;
						} else if (columnFieldTypes[index] == DataType.INT || columnFieldTypes[index] == DataType.NUMERIC || columnFieldTypes[index] == DataType.DOUBLE
								|| columnFieldTypes[index] == DataType.FLOAT || columnFieldTypes[index] == DataType.LONG) {
							value = TypeConvertor.toDataType(columnFieldTypes[index], 0);
						}
					}

					args.addArg(columnFieldTypes[index], value);
				}
				insertBatch.putArgs(args);
			}
		}
	}
}
