package com.bokesoft.yigo.mid.util;

import com.bokesoft.pub.mid.dict.DictMaintainProxy;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 字典结构维护工具类
 */
public class DictMaintainUtil {
	/**
	 * 字典结构重建
	 * @param context 上下文
	 * @param itemKey 字典标识
	 * @throws Throwable 异常
	 */
	public static void rebuild(DefaultContext context, String itemKey) throws Throwable{
		DictMaintainProxy proxy = new DictMaintainProxy();
		proxy.rebuildStruct(context, itemKey);
	}
	
	/**
	 * 字典结构重建
	 * @param context 上下文
	 * @param itemKey 字典标识
	 * @param clusterID 数据簇id
	 * @throws Throwable 异常
	 */
	public static void rebuild(DefaultContext context, String itemKey, long clusterID) throws Throwable{
		String key = itemKey + "#" + clusterID;
		DictMaintainProxy proxy = new DictMaintainProxy();
		proxy.rebuildStruct(context, key);
	}
}
