package com.bokesoft.yigo.mid.session;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.common.struct.PairItemList;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaCluster;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class ClusterSessionParaItemProvider implements
		ISessionParaItemsProvider {

	@Override
	public PairItemList loadItems(DefaultContext context, String user)
			throws Throwable {
		PairItemList items = new PairItemList();
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject operatorDataObject = metaFactory.getDataObject(SystemField.OPERATOR);
		MetaTable mainTable = operatorDataObject.getTable(SystemField.SYS_Operator);
		MetaColumn codeColumn = mainTable.get(SystemField.CODE_DICT_KEY);
		String sql = StringUtil.strcat("select ", mainTable.getOIDColumn().getBindingDBColumnName(), 
				" from ", mainTable.getBindingDBTableName(), " where ", "lower(",
				codeColumn.getBindingDBColumnName(), ")" , "=?");
		IDBManager dbManager = context.getDBManager();
		DataTable table = dbManager.execPrepareQuery(sql, user.toLowerCase());
		if ( table.first() ) {
			Long OID = TypeConvertor.toLong(table.getObject(0));
			MetaSetting setting = metaFactory.getSetting();
			if ( setting != null ) {
				MetaCluster cluster = setting.getCluster();
				if ( cluster != null ) {
					MetaTable clusterTable = operatorDataObject.getTable(SystemField.SYS_DataCluster);
					if( clusterTable == null ) {
						throw new MetaException(MetaException.DATA_CLUSTER_TABLE_UNDEFINED, 
								StringTable.getString(context.getEnv(), "", StringTable.DataClusterTableUndefined));						
					}
					MetaColumn clusterColumn = clusterTable.get(SystemField.SYS_DataCluster_ClusterID);
					if( clusterColumn == null ) {
						throw new MetaException(MetaException.OWNER_CLUSTERID_NOT_DEFINED, 
								StringTable.getString(context.getEnv(), "", StringTable.OwnerClusterIDNotDefined));
					}
					String clusterSOID = clusterTable.get(SystemField.SOID_SYS_KEY).getBindingDBColumnName();
							
					MetaDataObject refDataObject = metaFactory.getDataObject(cluster.getRefItemKey());
					mainTable = refDataObject.getMainTable();
					
					MetaColumn OIDColumn = mainTable.getOIDColumn();
					MetaColumn nameColumn = mainTable.get(SystemField.NAME_DICT_KEY);
					sql = StringUtil.strcat("select ", OIDColumn.getBindingDBColumnName(), ",",
							nameColumn.getBindingDBColumnName(), " from ", mainTable.getBindingDBTableName(),
							" where ", OIDColumn.getBindingDBColumnName(), " in (select ",
							clusterColumn.getBindingDBColumnName(), " from ", clusterTable.getBindingDBTableName(), " where ", clusterSOID, "=?)");
					table = dbManager.execPrepareQuery(sql, OID);
					table.beforeFirst();
					while ( table.next() ) {
						PairItem item = new PairItem();
						item.setValue(table.getObject(0));
						item.setCaption(table.getString(1));
						items.add(item);
					}
				}
			}
		}
		return items;
	}

}
