package com.bokesoft.yigo.mid.scheduler;

import com.bokesoft.yes.common.trace.TraceTools;
import com.bokesoft.yigo.common.trace.OverflowStrategy;
import com.bokesoft.yigo.common.trace.TraceFramework;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

/**
 * 数据记录框架对quartz框架的中任务做切面处理,包含：任务创建前初始化数据记录队列缓存、任务执行结束后，打印数据记录队列并清除队列缓存
 */
public class TraceFrameJobLisenter implements JobListener {
    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /**
     * 任务创建前初始化数据记录队列缓存
     * @param jobExecutionContext 执行上下文
     */
    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        TraceSystemManager.initializeTraceContext(
                TraceTools.createNanoId(), TraceTools.createNanoId(), "");
        TraceSystemManager.initializeDataTrace(30, OverflowStrategy.LOG_AND_DROP);
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {

    }

    /**
     * 任务执行结束后，打印数据记录队列并清除队列缓存
     * @param jobExecutionContext 执行上下文
     * @param e
     */
    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException e) {
        TraceSystemManager.printDataRecord();
        TraceSystemManager.clearDataTrace();
        TraceSystemManager.clearTraceContext();
    }
}
