package com.bokesoft.yigo.mid.rights;

import java.util.Collection;

import com.bokesoft.yes.mid.rights.IRightsProxy;
import com.bokesoft.yes.mid.rights.MidRightsProxyFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.rights.CustomRights;
import com.bokesoft.yigo.struct.rights.DictRights;
import com.bokesoft.yigo.struct.rights.EntryRights;
import com.bokesoft.yigo.struct.rights.FormRights;
import com.bokesoft.yigo.struct.rights.ServiceRights;

public class OperatorRightsProvider {
	IRightsProxy operatorRightsProxy = null;
	
	public OperatorRightsProvider(DefaultContext cxt) {
		operatorRightsProxy = MidRightsProxyFactory.getInstance().createOperatorRightsProxy(cxt);
	}
	
	
	/**
	 * 加载入口权限
	 * @param oid 操作员oid
	 * @return 返回入口权限
	 * @throws Throwable 异常
	 */
	public EntryRights loadEntryRights(long oid) throws Throwable{
		return this.operatorRightsProxy.loadEntryRights(oid);
	}
	
	/**
	 * 保存入口权限
	 * @param oid 操作员oid
	 * @param entryRights 入口权限
	 * @throws Throwable 异常
	 */
	public void saveEntryRights(long oid, EntryRights entryRights) throws Throwable{
		this.operatorRightsProxy.saveEntryRights(oid, entryRights);
	}
	
	/**
	 * 加载字典数据权限
	 * @param oid 操作员oid
	 * @param itemKey 字典标识
	 * @return 数据权限
	 * @throws Throwable 异常
	 */
	public DictRights loadDictRights(long oid, String itemKey) throws Throwable{
		return this.loadDictRights(oid, itemKey);
	}
	
	/**
	 * 保存数据权限
	 * @param oid 操作员oid
	 * @param dictRights 数据权限
	 * @throws Throwable 角色
	 */
	public void saveDictRights(long oid, DictRights dictRights) throws Throwable{
		this.operatorRightsProxy.saveDictRights(oid, dictRights, null, null, null);
	}
	
	/**
	 * 追加数据权限
	 * @param oid 操作员oid
	 * @param itemKey 字典标识
	 * @param bEmpty 空值是否有权限
	 * @param add 追加数据
	 * @param del 删除数据
	 * @throws Throwable 异常
	 */
	public void appendDictRights(long oid, String itemKey, boolean bEmpty, Collection<Long> add, Collection<Long> del, Collection<Long> read, Collection<Long> write) throws Throwable{
		this.operatorRightsProxy.saveDictEmptRights(bEmpty, oid, itemKey, null);
		this.operatorRightsProxy.appendDictRights(oid, itemKey, add, del, read, write);
	}
	
	/**
	 * 加载表单权限
	 * @param oid 操作员oid
	 * @param formKey 表单标识
	 * @return 表单权限
	 * @throws Throwable 异常
	 */
	public FormRights loadFormRights(long oid, String formKey) throws Throwable{
		return this.operatorRightsProxy.loadFormRights(oid, formKey);
	}
	
	/**
	 * 保存表单权限
	 * @param oid 操作员oid
	 * @param formRights 表单权限
	 * @throws Throwable 异常
	 */
	public void saveFormRights(long oid, FormRights formRights) throws Throwable{
		this.operatorRightsProxy.saveFormRights(oid, formRights);
	}
	
	/**
	 * 加载自定义权限
	 * @param oid 操作员oid
	 * @return 自定义权限
	 * @throws Throwable 异常
	 */
	public CustomRights loadCustomRights(long oid)throws Throwable{
		return this.operatorRightsProxy.loadCustomRights(oid);
	}
	
	/**
	 * 保存自定义权限
	 * @param oid 操作员oid
	 * @param rights 自定义权限
	 * @throws Throwable 异常
	 */
	public void saveCustomRights(long oid, CustomRights rights) throws Throwable{
		this.operatorRightsProxy.saveCustomRights(oid, rights);
	}
	
	/**
	 * 加载服务调用权限
	 * @param oid 操作员oid
	 * @return 服务权限
	 * @throws Throwable 异常
	 */
	public ServiceRights loadServiceRights(long oid)throws Throwable{
		return this.operatorRightsProxy.loadServiceRights(oid);
	}
	
	/**
	 * 保存服务调用权限（不再用了）
	 * @param oid 操作员oid
	 * @param rights 服务权限
	 * @throws Throwable 异常
	 */
	public void saveServiceRights(long oid, ServiceRights rights)throws Throwable{
		this.operatorRightsProxy.saveServiceRights(oid, rights);
	}	
}
