package com.bokesoft.yigo.mid.rights;

import com.bokesoft.yes.mid.rights.IRightsProvider;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yigo.mid.base.RightsContext;
import com.bokesoft.yigo.struct.rights.FormRights;
/**
 * 用于加载表单默认的权限
 * @author 陈瑞
 *
 */
public class DefaultFormRightsLoader {
	
	public DefaultFormRightsLoader() {
		
	}
	
	/**
	 *  加载表单默认权限
	 * @param context 上下文
	 * @return 权限
	 * @throws Throwable 加载过程中可能产生的异常
	 */
	public RightsObject load(RightsContext context) throws Throwable {
		String formKey = context.getFormKey();
		
		IRightsProvider userRights = RightsProviderFactory.getInstance().newRightsProvider(context);
		FormRights formRights = userRights.getFormRights(formKey);

		RightsObject rights = new RightsObject(formKey);
		rights.fromJSON(formRights.toJSON());
		return rights;
	}
	
}
