package com.bokesoft.yigo.mid.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.TreeSet;

import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.calculate.MetaMapParas;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

public class MapedDataQuery {

	private Long OID = null;

	private String mapKey = "";

	public MapedDataQuery(Long OID, String mapKey) {
		this.OID = OID;
		this.mapKey = mapKey;
	}

	public TreeSet<Long> query(BaseContext context) throws Throwable {
		TreeSet<Long> set = new TreeSet<>();
		IDBManager DBManager = context.getDBManager();
		IMetaFactory factory = context.getVE().getMetaFactory();

		MetaMap map = factory.getDataMap(mapKey);
		MetaMapParas mapParas = map.getDataMapParas(factory);
		StringBuilder sb = new StringBuilder("select ");
		MetaTable tgtTable = factory.getDataObject(map.getTgtDataObjectKey()).getTable(mapParas.getPrimaryTgtTableKey());

		sb.append(DBManager.keyWordEscape(tgtTable.getSOIDColumn().getBindingDBColumnName()));
		sb.append(",");
		sb.append(DBManager.keyWordEscape(tgtTable.getMAPKEYColumn().getBindingDBColumnName()));
		sb.append(" from ");
		sb.append(DBManager.keyWordEscape(tgtTable.getBindingDBTableName()));
		sb.append(" where ");
		sb.append(DBManager.keyWordEscape(tgtTable.getSrcSOIDColumn().getBindingDBColumnName()));
		sb.append(" =? ");

		String sql = sb.toString();
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			ps.setLong(1, OID);

			PSArgs args = new PSArgs();
			args.addLongArg(OID);
			rs = DBManager.executeQuery(ps, sql, args);
			while (rs.next()) {
				String mk = rs.getString(2);
				if (mk.equals(mapKey)) {
					set.add(rs.getLong(1));
				}
			}
		} finally {
			if (rs != null)
				rs.close();
			if (ps != null)
				ps.close();
		}
		return set;
	}

}
