package com.bokesoft.yigo.mid.process;

import java.util.Map;

import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.extend.IMidProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;

/**
 * 获取锁定账户二开
 * 
 * 
 */
public class GetLockAccountsProcess implements IMidProcess<DefaultContext>{

	private static final String tableKey = "LockAccounts";
	
	
	@Override
	public Object process(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(context.getFormKey());
		MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
		
		MetaTable metaTable = dataObject.getTable(tableKey);
		
		DataTable table = DataTableUtil.newEmptyDataTable(metaTable);

		loadUser(table,context);
		return table;
	}

	private void loadUser(DataTable table,DefaultContext context) {
		IAccountLockoutInfoMap accountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
		
		Map<String , IAccountLockoutInfo> infos= accountLockoutInfoMap.updateAccountLockMap(context);

		IAccountLockoutInfo lockInfo = null;
		for (String key : infos.keySet()) {
			lockInfo = accountLockoutInfoMap.get(key);
			if ( lockInfo == null) {
				continue;
			}
			String[] args = key.split("_");

			table.append();
			// 记录的字段
			table.setObject("OperatorID", args[0]);			
			table.setObject("Mode", args[1]);
			table.setObject("LockTime", lockInfo.getLockDate());
		}
	}
}
