package com.bokesoft.yigo.mid.map;

import com.bokesoft.yes.mid.datamap.calculate.MapMidUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 中间层下推的工具类（会执行分组分量的逻辑）
 * 
 * @author 刘翔翔
 *
 */
public class MapData {

	/** 映射 KEY */
	private String mapKey;

	/**
	 * 设置映射的 KEY
	 * 
	 * @param mapKey
	 */
	public MapData(String mapKey) {
		this.mapKey = mapKey;
	}

	/**
	 * 执行数据映射并将结果保存
	 * 
	 * @param context 上下文
	 * @throws Throwable
	 * @return 成功执行映射,返回true,无映射量返回false
	 */
	public boolean map(DefaultContext context) throws Throwable {
		return MapMidUtil.midMapData(context, mapKey);
	}
}
