package com.bokesoft.yigo.mid.log;

import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.variant.log.ILogArchiveIO;

public class LogArchiveIOFactory {
	
	public static ILogArchiveIO getArchiveIO(DefaultContext context, String type) throws Throwable {
		String impl = null;
		if ("es".equalsIgnoreCase(type)) {
			impl = "com.bokesoft.yes.variant.bpm.BPMLogArchiveESIO";
		}
		
		ILogArchiveIO io = null;
		if (impl != null) {
			io = (ILogArchiveIO) ReflectHelper.newInstance(context.getVE(), impl);
		}
		return io;
	}
}
